# tests for feature pre-processing functions.
# library(scuttle); library(testthat); source("setup.R"); source("test-feat-proc.R")

test_that("we can uniquify the feature names", {
    all.genes <- sample(c(LETTERS, LETTERS[1:5], NA, NA))
    all.ids <- paste0("GENE", seq_along(all.genes))
    out <- uniquifyFeatureNames(all.ids, all.genes)
    out.factor.names <- uniquifyFeatureNames(all.ids, factor(all.genes))
    out.factor.id <- uniquifyFeatureNames(factor(all.ids), all.genes)
    
    lost <- is.na(all.genes)
    expect_identical(out[lost], all.ids[lost])
    dup <- all.genes %in% all.genes[duplicated(all.genes)]
    expect_identical(out[!dup & !lost], all.genes[!dup & !lost])
    expect_identical(out[dup & !lost], paste0(all.genes, "_", all.ids)[dup & !lost])
    
    expect_identical(out, out.factor.names)
    expect_identical(out, out.factor.id)
})

