% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{TCGAvisualize_SurvivalCoxNET}
\alias{TCGAvisualize_SurvivalCoxNET}
\title{Survival analysis with univariate Cox regression package (dnet)}
\usage{
TCGAvisualize_SurvivalCoxNET(
  clinical_patient,
  dataGE,
  Genelist,
  org.Hs.string,
  scoreConfidence = 700,
  titlePlot = "TCGAvisualize_SurvivalCoxNET Example"
)
}
\arguments{
\item{clinical_patient}{is a data.frame using function 'clinic' with information
related to barcode / samples such as bcr_patient_barcode, days_to_death ,
days_to_last_followup , vital_status, etc}

\item{dataGE}{is a matrix of Gene expression (genes in rows, samples in cols) from TCGAprepare}

\item{Genelist}{is a list of gene symbols where perform survival KM.}

\item{org.Hs.string}{an igraph object that contains a functional protein association network
in human. The network is extracted from the STRING database (version 10).}

\item{scoreConfidence}{restrict to those edges with high confidence (eg. score>=700)}

\item{titlePlot}{is the title to show in the final plot.}
}
\value{
net IGRAPH with related Cox survival genes in community (same pval and color) and with
interactions from STRING database.
}
\description{
TCGAvisualize_SurvivalCoxNET can help an user to identify a group of survival genes that are
significant from univariate Kaplan Meier Analysis and also for Cox Regression.
It shows in the end a network build with community of genes with similar range of pvalues from
Cox regression (same color) and that interaction among those genes is already validated in
literatures using the STRING database (version 9.1).
TCGAvisualize_SurvivalCoxNET perform survival analysis with univariate Cox regression
and package (dnet) using following functions wrapping from these packages:
\enumerate{
\item survival::coxph
\item igraph::subgraph.edges
\item igraph::layout.fruchterman.reingold
\item igraph::spinglass.community
\item igraph::communities
\item dnet::dRDataLoader
\item dnet::dNetInduce
\item dnet::dNetPipeline
\item dnet::visNet
\item dnet::dCommSignif
}
}
\details{
TCGAvisualize_SurvivalCoxNET allow user to perform the complete workflow using coxph
and dnet package related to survival analysis with an identification of gene-active networks from
high-throughput omics data using gene expression and clinical data.
\enumerate{
\item Cox regression survival analysis to obtain hazard ratio (HR) and p-values
\item fit a Cox proportional hazards model and ANOVA (Chisq test)
\item Network comunites
\item An igraph object that contains a functional protein  association network in human.
The network is extracted from the STRING database (version 9.1).
Only those associations with medium confidence (score>=400) are retained.
\item restrict to those edges with high confidence (score>=700)
\item extract network that only contains genes in pvals
\item Identification of gene-active network
\item visualisation of the gene-active network itself
\item the layout of the network visualisation (fixed in different visuals)
\item color nodes according to communities (identified via a spin-glass model and simulated annealing)
\item node sizes according to degrees
\item highlight different communities
\item visualize the subnetwork
}
}
