% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ansiex.R
\name{ansi_strwrap}
\alias{ansi_strwrap}
\title{Wrap an ANSI styled string to a certain width}
\usage{
ansi_strwrap(
  x,
  width = console_width(),
  indent = 0,
  exdent = 0,
  simplify = TRUE
)
}
\arguments{
\item{x}{ANSI string.}

\item{width}{Width to wrap to.}

\item{indent}{Indentation of the first line of each paragraph.}

\item{exdent}{Indentation of the subsequent lines of each paragraph.}

\item{simplify}{Whether to return all wrapped strings in a single
character vector, or wrap each element of \code{x} independently and return
a list.}
}
\value{
If \code{simplify} is \code{FALSE}, then a list of character vectors,
each an ANSI string. Otherwise a single ANSI string vector.
}
\description{
This function is similar to \code{\link[base:strwrap]{base::strwrap()}}, but works on ANSI
styled strings, and leaves the styling intact.
}
\examples{
text <- cli:::lorem_ipsum()
# Highlight some words, that start with 's'
rexp <- gregexpr("\\\\b([sS][a-zA-Z]+)\\\\b", text)
regmatches(text, rexp) <- lapply(regmatches(text, rexp), col_red)
cat(text)

wrp <- ansi_strwrap(text, width = 40)
cat(wrp, sep = "\n")
}
\seealso{
Other ANSI string operations: 
\code{\link{ansi_align}()},
\code{\link{ansi_columns}()},
\code{\link{ansi_nchar}()},
\code{\link{ansi_strsplit}()},
\code{\link{ansi_strtrim}()},
\code{\link{ansi_substring}()},
\code{\link{ansi_substr}()},
\code{\link{ansi_toupper}()},
\code{\link{ansi_trimws}()}
}
\concept{ANSI string operations}
