% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-count.R
\name{count.tbl_lazy}
\alias{count.tbl_lazy}
\alias{tally.tbl_lazy}
\title{Count observations by group}
\usage{
\method{count}{tbl_lazy}(x, ..., wt = NULL, sort = FALSE, name = NULL)

\method{tally}{tbl_lazy}(x, wt = NULL, sort = FALSE, name = NULL)
}
\arguments{
\item{x}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr).}

\item{...}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Variables, or functions of
variables. Use \code{\link[dplyr:desc]{desc()}} to sort a variable in descending order.}

\item{wt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Frequency weights.
Can be \code{NULL} or a variable:
\itemize{
\item If \code{NULL} (the default), counts the number of rows in each group.
\item If a variable, computes \code{sum(wt)} for each group.
}}

\item{sort}{If \code{TRUE}, will show the largest groups at the top.}

\item{name}{The name of the new column in the output.

If omitted, it will default to \code{n}. If there's already a column called \code{n},
it will error, and require you to specify the name.}
}
\description{
These are methods for the dplyr \code{\link[=count]{count()}} and \code{\link[=tally]{tally()}} generics. They
wrap up \code{\link[=group_by.tbl_lazy]{group_by.tbl_lazy()}}, \code{\link[=summarise.tbl_lazy]{summarise.tbl_lazy()}} and, optionally,
\code{\link[=arrange.tbl_lazy]{arrange.tbl_lazy()}}.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

db <- memdb_frame(g = c(1, 1, 1, 2, 2), x = c(4, 3, 6, 9, 2))
db \%>\% count(g) \%>\% show_query()
db \%>\% count(g, wt = x) \%>\% show_query()
db \%>\% count(g, wt = x, sort = TRUE) \%>\% show_query()
}
