% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curly.R
\name{curly}
\alias{curly}
\title{Adds curly brackets to plot}
\usage{
curly(x, y, len = 1, theta = 0, wid, shape = 1, col = 1, lwd = 1,
  lty = 1, grid = FALSE, npoints = 50, text = NULL,
  offset = c(0.05, 0))
}
\arguments{
\item{x}{center of the x axis of the curly brackets (or start end coordinates (x1,x2))}

\item{y}{center of the y axis of the curly brackets (or start end coordinates (y1,y2))}

\item{len}{Length of the curly brackets}

\item{theta}{angle (in radians) of the curly brackets orientation}

\item{wid}{Width of the curly brackets}

\item{shape}{shape (curvature)}

\item{col}{color (passed to lines/grid.lines)}

\item{lwd}{line width (passed to lines/grid.lines)}

\item{lty}{line type (passed to lines/grid.lines)}

\item{grid}{If TRUE use grid graphics (compatability with ggplot2)}

\item{npoints}{Number of points used in curves}

\item{text}{Label}

\item{offset}{Label offset (x,y)}
}
\description{
Adds curly brackets to plot
}
\examples{
if (interactive()) {
plot(0,0,type="n",axes=FALSE,xlab="",ylab="")
curly(x=c(1,0),y=c(0,1),lwd=2,text="a")
curly(x=c(1,0),y=c(0,1),lwd=2,text="b",theta=pi)
curly(x=-0.5,y=0,shape=1,theta=pi,text="c")
curly(x=0,y=0,shape=1,theta=0,text="d")
curly(x=0.5,y=0,len=0.2,theta=pi/2,col="blue",lty=2)
curly(x=0.5,y=-0.5,len=0.2,theta=-pi/2,col="red",shape=1e3,text="e")
}
}
