% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multcomp.R
\name{estfun}
\alias{estfun}
\alias{estfun.lvmfit}
\alias{estfun.gls}
\alias{estfun.lme}
\title{Extract Empirical Estimating Functions (lvmfit Object)}
\usage{
\method{estfun}{lvmfit}(x, ...)

\method{estfun}{gls}(x, ...)

\method{estfun}{lme}(x, ...)
}
\arguments{
\item{x}{an \code{lvmfit} object.}

\item{...}{arguments passed to methods.}
}
\description{
Extract the empirical estimating functions of a lvmfit object.
This function is for internal use but need to be public to enable its use by \code{multcomp::glht}.
}
\details{
This function enables to use the \code{glht} function with lvmfit object.
Otherwise when calling \code{multcomp:::vcov.mmm} then \code{sandwich::sandwich} and then \code{sandwich::meat}, \code{sandwich::meat} will complain that \code{estfun} is not defined for \code{lvmfit} objects.
}
\examples{
library(multcomp)

#### generative model ####
mSim <- lvm(X ~ Age + 0.5*Treatment,
            Y ~ Gender + 0.25*Treatment,
            c(Z1,Z2,Z3) ~ eta, eta ~ 0.75*treatment,
            Age[40:5]~1)
latent(mSim) <- ~eta
categorical(mSim, labels = c("placebo","SSRI")) <- ~Treatment
categorical(mSim, labels = c("male","female")) <- ~Gender

#### simulate data ####
n <- 5e1
set.seed(10)
df.data <- lava::sim(mSim, n = n, latent = FALSE)

#### fit separate models ####
lmX <- lm(X ~ Age + Treatment, data = df.data)
lvmY <- estimate(lvm(Y ~ Gender + Treatment), data = df.data)
lvmZ <- estimate(lvm(c(Z1,Z2,Z3) ~ eta, eta ~ Treatment), 
                 data = df.data)

#### create mmm object #### 
e.mmm <- mmm(X = lmX, Y = lvmY, Z = lvmZ)

#### create contrast matrix ####
resC <- createContrast(e.mmm, var.test = "Treatment", add.variance = FALSE)

#### adjust for multiple comparisons ####
e.glht <- glht(e.mmm, linfct = resC$mlf)
summary(e.glht)
}
\concept{multiple comparison}
