\name{arrange}
\alias{arrange}
\title{Order a data frame by its colums.}
\usage{
  arrange(df, ...)
}
\arguments{
  \item{df}{data frame to reorder}

  \item{...}{expressions evaluated in the context of
  \code{df} and then fed to \code{\link{order}}}
}
\description{
  This function completes the subsetting, transforming and
  ordering triad with a function that works in a similar
  way to \code{\link{subset}} and \code{\link{transform}}
  but for reordering a data frame by its columns. This
  saves a lot of typing!
}
\examples{
# sort mtcars data by cylinder and displacement
mtcars[with(mtcars, order(cyl, disp)), ]
# Same result using arrange: no need to use with(), as the context is implicit
# NOTE: plyr functions do NOT preserve row.names
arrange(mtcars, cyl, disp)
# Let's keep the row.names in this example
myCars = cbind(vehicle=row.names(mtcars), mtcars)
arrange(myCars, cyl, disp)
# Sort with displacement in descending order
arrange(myCars, cyl, desc(disp))
}
\seealso{
  \code{\link{order}} for sorting function in the base
  package
}
\keyword{manip}

