% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAdditionalData.R
\name{getAdditionalData}
\alias{getAdditionalData}
\title{Get Additional Data}
\usage{
getAdditionalData(fileName,
  repoURL = "http://ecdc.europa.eu/sites/portal/files/documents",
  savePath = NULL)
}
\arguments{
\item{fileName}{Name of the file to download. Required.}

\item{repoURL}{Web address of the remote repository of files to download from. Required.
Default = \code{"http://ecdc.europa.eu/sites/portal/files/documents"}}

\item{savePath}{Folder to save the downloaded and unzipped (if needed) file. File is saved only
if this argument is not \code{NULL}. Optional. Default = \code{NULL}.}
}
\value{
Data object
}
\description{
Retrieves additional data from internet. This can be any file type, but the purpose of this
function is to download data such as longitudinal response parameters from an online repository.
}
\examples{

\dontrun{
getAdditionalData(fileName = "coxiellaIFAParams4.zip")
getAdditionalData(fileName = "yersiniaSSIParams4.zip")
getAdditionalData(fileName = "coxiellaIFAParams4.zip", savePath = getwd())
getAdditionalData(fileName = "yersiniaSSIParams4.zip", savePath = getwd())
}

}
