% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logmap.R
\name{LogMap-validity}
\alias{LogMap-validity}
\title{Logical Map Validity}
\description{
Validation of \code{LogMap} objects is handled by
\code{\link[methods]{validObject}}
}
\section{Data Validation}{

Logical maps must be a logical matrix containing only TRUE or FALSE values
}

\section{Value Validation}{

All values must be named within the rownames of the object. Duplicate or
empty (\code{""}) values are not allowed
}

\section{Observation Validation}{

All observations must be named within the column names of the object.
Duplicate or empty (\code{""}) observations are not allowed
}

\examples{
map <- LogMap(letters[1:10])
map[['obs']] <- c(1, 3, 7)
map[['entry']] <- c(2, 7, 10)
validObject(map)

}
\seealso{
\code{\link[methods]{validObject}}

Logical map objects, validity, and interaction methods:
\code{\link{LogMap}},
\code{\link{as.matrix.LogMap}()},
\code{\link{droplevels.LogMap}()},
\code{\link{intersect.LogMap}()},
\code{\link{labels.LogMap}()}
}
\concept{logmap}
