% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expectations.r
\name{expect_is}
\alias{expect_is}
\title{Expectation: does the object inherit from a class?}
\usage{
expect_is(object, class, info = NULL, label = NULL)
}
\arguments{
\item{object}{object to test}

\item{class}{character vector of class names}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}
}
\description{
Tests whether or not an object inherits from any of a list of classes.
}
\examples{
expect_is(1, "numeric")
a <- matrix(1:10, nrow = 5)
expect_is(a, "matrix")

expect_is(mtcars, "data.frame")
# alternatively for classes that have an is method
expect_true(is.data.frame(mtcars))
}
\seealso{
\code{\link{inherits}}

Other expectations: \code{\link{equivalence}},
  \code{\link{expect_equal}},
  \code{\link{expect_equivalent}},
  \code{\link{expect_identical}};
  \code{\link{expect-compare}}, \code{\link{expect_gt}},
  \code{\link{expect_gte}}, \code{\link{expect_less_than}},
  \code{\link{expect_lt}}, \code{\link{expect_lte}},
  \code{\link{expect_more_than}};
  \code{\link{expect_equal_to_reference}};
  \code{\link{expect_error}}, \code{\link{expect_match}},
  \code{\link{expect_message}},
  \code{\link{expect_output}},
  \code{\link{expect_warning}},
  \code{\link{matching-expectations}};
  \code{\link{expect_false}}, \code{\link{expect_true}};
  \code{\link{expect_named}}; \code{\link{expect_null}};
  \code{\link{expect_silent}};
  \code{\link{takes_less_than}}
}

