% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/language.R
\name{with_language}
\alias{with_language}
\alias{local_language}
\title{Language}
\usage{
with_language(lang, code)

local_language(lang, .local_envir = parent.frame())
}
\arguments{
\item{lang}{A BCP47 language code like "en" (English), "fr" (French),
"fr_CA" (French Canadian). Formally, this is a lower case two letter
\href{https://en.wikipedia.org/wiki/List_of_ISO_639-1_codes}{ISO 639 country code},
optionally followed by "_" or "-" and an upper case two letter
\href{https://en.wikipedia.org/wiki/ISO_3166-2}{ISO 3166 region code}.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\description{
Temporarily change the language used for translations.
}
\examples{
with_language("en", try(mean[[1]]))
with_language("fr", try(mean[[1]]))
with_language("es", try(mean[[1]]))
}
