% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{qi_slimmer}
\alias{qi_slimmer}
\title{Find the median and a central interval of simulated quantity of interest
distributions}
\usage{
qi_slimmer(df, qi_type = "ev", ci = 0.95)
}
\arguments{
\item{df}{a tidy-formatted data frame of simulated quantities of interest
created by \code{\link{zelig_qi_to_df}}.}

\item{qi_type}{character string either \code{ev} or \code{pv} for returning the
central intervals for the expected value or predicted value, respectively.}

\item{ci}{numeric. The central interval to return, expressed on the
\verb{(0, 100]} or the equivalent \verb{(0, 1]} interval.}
}
\description{
Find the median and a central interval of simulated quantity of interest
distributions
}
\details{
A tidy-formatted data frame with the following columns:
\itemize{
\item The values fitted with \code{\link{setx}}
\item \code{qi_ci_min}: the minimum value of the central interval specified with
\code{ci}
\item \code{qi_ci_median}: the median of the simulated quantity of interest
distribution
\item \code{qi_ci_max}: the maximum value of the central interval specified with
\code{ci}
}
}
\examples{
library(dplyr)
qi.central.interval <- zelig(Petal.Width ~ Petal.Length + Species,
             data = iris, model = "ls") \%>\%
             setx(Petal.Length = 2:4, Species = "setosa") \%>\%
             sim() \%>\%
             zelig_qi_to_df() \%>\%
             qi_slimmer()

}
\seealso{
\code{\link{zelig_qi_to_df}}
}
\author{
Christopher Gandrud
}
