// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2020 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from Net.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.net {

  public class InterfaceIpSettings : ICloneable {
    public object Clone() {
      InterfaceIpSettings copy = new InterfaceIpSettings();
      copy.enabled = this.enabled;
      copy.configMethod = this.configMethod;
      copy.staticAddrCidr = this.staticAddrCidr;
      copy.dhcpPreferredHostname = this.dhcpPreferredHostname;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["enabled"] = this.enabled;
      json["configMethod"] = (int)this.configMethod;
      json["staticAddrCidr"] = this.staticAddrCidr.Encode();
      json["dhcpPreferredHostname"] = this.dhcpPreferredHostname;
      return json;
    }

    public static InterfaceIpSettings Decode(LightJson.JsonObject json, Agent agent) {
      InterfaceIpSettings inst = new InterfaceIpSettings();
      inst.enabled = (bool)json["enabled"];
      inst.configMethod = (Com.Raritan.Idl.net.IpConfigMethod)(int)json["configMethod"];
      inst.staticAddrCidr = Com.Raritan.Idl.net.IpAddrCidr.Decode(json["staticAddrCidr"], agent);
      inst.dhcpPreferredHostname = (string)json["dhcpPreferredHostname"];
      return inst;
    }

    public bool enabled = false;
    public Com.Raritan.Idl.net.IpConfigMethod configMethod = Com.Raritan.Idl.net.IpConfigMethod.STATIC;
    public Com.Raritan.Idl.net.IpAddrCidr staticAddrCidr = new Com.Raritan.Idl.net.IpAddrCidr();
    public string dhcpPreferredHostname = "";
  }
}
