// SPDX-FileCopyrightText: 2022 Heiko Schaefer <heiko@schaefer.name>
// SPDX-License-Identifier: MIT OR Apache-2.0

//! OID constants

pub(crate) const NIST_P256R1: &[u8] = &[0x2A, 0x86, 0x48, 0xCE, 0x3D, 0x03, 0x01, 0x07];
pub(crate) const NIST_P384R1: &[u8] = &[0x2B, 0x81, 0x04, 0x00, 0x22];
pub(crate) const NIST_P521R1: &[u8] = &[0x2B, 0x81, 0x04, 0x00, 0x23];
pub(crate) const BRAINPOOL_P256R1: &[u8] = &[0x2B, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x07];
pub(crate) const BRAINPOOL_P384R1: &[u8] = &[0x2B, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0b];
pub(crate) const BRAINPOOL_P512R1: &[u8] = &[0x2B, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0d];
pub(crate) const SECP256K1: &[u8] = &[0x2B, 0x81, 0x04, 0x00, 0x0A];
pub(crate) const ED25519: &[u8] = &[0x2B, 0x06, 0x01, 0x04, 0x01, 0xDA, 0x47, 0x0F, 0x01];
pub(crate) const CV25519: &[u8] = &[0x2b, 0x06, 0x01, 0x04, 0x01, 0x97, 0x55, 0x01, 0x05, 0x01];
pub(crate) const ED448: &[u8] = &[0x2b, 0x65, 0x71];
pub(crate) const X448: &[u8] = &[0x2b, 0x65, 0x6f];

// Values taken from https://www.gnupg.org/ftp/specs/OpenPGP-smart-card-application-2.1.pdf
// section "7.2.8.2 DigestInfo for RSA"
pub(crate) const SHA1: &[u8] = &[0x2b, 0x0e, 0x03, 0x02, 0x1a];
pub(crate) const SHA256: &[u8] = &[0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x01];
pub(crate) const SHA384: &[u8] = &[0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x02];
pub(crate) const SHA512: &[u8] = &[0x60, 0x86, 0x48, 0x01, 0x65, 0x03, 0x04, 0x02, 0x03];
