// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "magnifierpseudo.h"

// Tk Canvas Widget Function Declarations

int MagnifierPseudoColorCreateProc(Tcl_Interp*, Tk_Canvas, Tk_Item*, int, 
				   Tcl_Obj *const []);

// MagnifierPseudoColor Specs

static Tk_CustomOption tagsOption = {
  Tk_CanvasTagsParseProc, Tk_CanvasTagsPrintProc, NULL
};

static Tk_ConfigSpec magnifierPseudoColorSpecs[] = {

  {TK_CONFIG_STRING, (char*)"-command", NULL, NULL, "magnifier",
   Tk_Offset(WidgetOptions, cmdName), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, (char*)"-x", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, x), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, (char*)"-y", NULL, NULL, "1",
   Tk_Offset(WidgetOptions, y), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, (char*)"-width", NULL, NULL, "256",
   Tk_Offset(WidgetOptions, width), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_INT, (char*)"-height", NULL, NULL, "256",
   Tk_Offset(WidgetOptions, height), TK_CONFIG_OPTION_SPECIFIED, NULL},
  {TK_CONFIG_ANCHOR, (char*)"-anchor", NULL, NULL, "nw",
   Tk_Offset(WidgetOptions, anchor), 0, NULL},
  {TK_CONFIG_CUSTOM, (char*)"-tags", NULL, NULL, NULL,
   0, TK_CONFIG_NULL_OK, &tagsOption},

  {TK_CONFIG_STRING, (char*)"-helvetica", NULL, NULL, "helvetica",
   Tk_Offset(WidgetOptions, helvetica), 0, NULL},
  {TK_CONFIG_STRING, (char*)"-courier", NULL, NULL, "courier",
   Tk_Offset(WidgetOptions, courier), 0, NULL},
  {TK_CONFIG_STRING, (char*)"-times", NULL, NULL, "times",
   Tk_Offset(WidgetOptions, times), 0, NULL},

  {TK_CONFIG_END, NULL, NULL, NULL, NULL, 0, 0, NULL},
};

// Tk Static Structure

static Tk_ItemType magnifierPseudoColorType = {
  (char*)"magnifierpseudocolor",       // name
  sizeof(WidgetOptions),        // size
  MagnifierPseudoColorCreateProc,  // configProc
  magnifierPseudoColorSpecs,    // configSpecs
  WidgetConfigProc,             // configProc
  WidgetCoordProc,              // coordProc
  WidgetDeleteProc,             // deleteProc
  WidgetDisplayProc,            // displayProc
  0,                            // alwaysRedraw
  WidgetPointProc,              // pointProc
  WidgetAreaProc,               // areaProc
  WidgetPostscriptProc,         // postscriptProc
  WidgetScaleProc,              // scaleProc
  WidgetTranslateProc,          // translateProc
  (Tk_ItemIndexProc*)NULL,      // indexProc
  (Tk_ItemCursorProc*)NULL,     // icursorProc
  (Tk_ItemSelectionProc*)NULL,  // selectionProc
  (Tk_ItemInsertProc*)NULL,     // insertProc
  (Tk_ItemDCharsProc*)NULL,     // dCharsProc
  (Tk_ItemType*)NULL            // nextPtr
};

// Non-Member Functions

int MagnifierPseudoColor_Init(Tcl_Interp* interp)
{
  Tk_CreateItemType(&magnifierPseudoColorType);
  return TCL_OK;
}

int MagnifierPseudoColorCreateProc(Tcl_Interp* interp, Tk_Canvas canvas, 
				   Tk_Item* item, 
				   int argc, Tcl_Obj *const argv[])
{
  MagnifierPseudoColor* magnifier = 
    new MagnifierPseudoColor(interp, canvas, item);

  // and set default configuration

  if (magnifier->configure(argc, (const char**)argv, 0) != TCL_OK) {
    delete magnifier;
    Tcl_AppendResult(interp, " error occured while creating magnifier.", NULL);
    return TCL_ERROR;
  }

  return TCL_OK;
}

MagnifierPseudoColor::MagnifierPseudoColor(Tcl_Interp* i, Tk_Canvas c, 
					   Tk_Item* item)
  : Magnifier(i, c, item)
{
  configSpecs = magnifierPseudoColorSpecs;  // magnifier configure options
}

void MagnifierPseudoColor::clearPixmap()
{
  XSetForeground(display, gc, getColor("white"));
  XFillRectangle(display, pixmap, gc, 0, 0, options->width, options->height);
}
