/*
  test.cc, copyright (c) 2006 by Vincent Fourmond: 
  A small test program for SCalc.
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details (in the COPYING file).
  
*/

#include <scalc.hh>
using namespace SCalc;
using namespace std;

extern int yydebug;

void dump(ParserResult * r)
{
  if(r->is_expression() && r->to_expression()->is_valid())
    {
      Expression * e = r->to_expression();
      set<int> vars = e->used_variables();
      cerr << "Pretty: " << e->pretty_print() << endl;
      cerr << e->used_variables().size() << " variables used" << endl;
//       for(set<int>::iterator i = vars.begin(); i != vars.end(); i++)
// 	cerr << "Used var : " << *i << endl;
      if(e->evaluable())
	cerr << "  Evaluable -> " << e->evaluate() << endl;
      else
	cerr << "  Cannot be evaluated yet" << endl;
      Expression * s= e->simplify();
      cerr << "  Simplified : " << s->pretty_print() << endl;
      // now, we try derivation with regards to the first variable:
      Expression * der = e->derive(0);
      cerr << "Derivative with regards to var 0 : ";
      cerr << der->pretty_print() << endl;
      delete s;
      s = der->simplify();
      cerr << "  Simplified derivative : " << s->pretty_print() << endl;
      if(s->evaluable())
	cerr << "  Evaluable -> " << s->evaluate() << endl;
      else
	cerr << "  Cannot be evaluated yet" << endl;
      delete s;
      delete der;
      delete e;
    }
  else
    {
      cerr << r->pretty_print() << endl;
      if(! r->is_func_def() || r->to_func_def()->name().empty())
	delete r;
    }
}

int
main (void)
{
  Session s;
  string str;
  while(!cin.eof())
    {
      cerr << "Function table :" << endl;
      vector<string> funcnames = s.func_names();
      for(size_t i = 0; i < funcnames.size(); i++)
	cerr << "Function #" << i << " : " << funcnames[i] << endl;
      getline(cin,str);
      if(!str.empty())
	{
	  dump(s.eval(str.c_str()));
// 	  vector<string> varnames = s.varnames();
// 	  for(size_t i = 0; i < varnames.size(); i++)
// 	    cerr << "Variable #" << i << " : " << varnames[i] << endl;
	}
    }
}
