/*
 * Decompiled with CFR 0.152.
 */
package org.sikuli.guide;

import java.awt.AWTException;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.sikuli.guide.Annotation;
import org.sikuli.guide.AnnotationArrow;
import org.sikuli.guide.AnnotationHighlight;
import org.sikuli.guide.AnnotationOval;
import org.sikuli.guide.AnnotationRectangle;
import org.sikuli.guide.AnnotationToolTip;
import org.sikuli.guide.ClickTarget;
import org.sikuli.guide.Flag;
import org.sikuli.guide.NavigationDialog;
import org.sikuli.guide.Spotlight;
import org.sikuli.script.Debug;
import org.sikuli.script.Env;
import org.sikuli.script.Location;
import org.sikuli.script.OS;
import org.sikuli.script.Region;
import org.sikuli.script.Screen;
import org.sikuli.script.TransparentWindow;

public class SikuliGuide
extends TransparentWindow {
    static final float DEFAULT_SHOW_DURATION = 10.0f;
    public static final int FIRST = 0;
    public static final int MIDDLE = 1;
    public static final int LAST = 2;
    public static final int SIMPLE = 4;
    Robot robot;
    Region _region;
    JPanel content = new JPanel(null);
    ArrayList<Annotation> _annotations = new ArrayList();
    ArrayList<ClickTarget> _clickTargets = new ArrayList();
    ClickTarget _clickTarget = null;
    Spotlight spotlight = null;
    NavigationDialog dialog = null;
    ClickTarget _lastClickedTarget = null;

    public Region getRegion() {
        return this._region;
    }

    public SikuliGuide() {
        this.init((Region)new Screen());
    }

    public SikuliGuide(Region region) {
        this.init(region);
    }

    void init(Region region) {
        try {
            this.robot = new Robot();
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
        this._region = region;
        Rectangle rectangle = this._region.getRect();
        this.content.setPreferredSize(rectangle.getSize());
        this.add(this.content);
        this.setBounds(rectangle);
        Color color = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBackground(color);
        this.content.setBackground(color);
        if (Env.getOS() == OS.WINDOWS) {
            Env.getOSUtil().setWindowOpaque((JWindow)((Object)this), false);
        }
        this.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE);
        ((JPanel)this.getContentPane()).setDoubleBuffered(true);
        this.setVisible(false);
        this.setAlwaysOnTop(true);
        this.setFocusableWindowState(false);
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        super.paint(graphics);
        for (Annotation annotation : this._annotations) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            annotation.paintAnnotation(graphics2D);
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.0f));
        }
    }

    public void clear() {
        this._annotations.clear();
        this.content.removeAll();
        this.dialog = null;
        this.spotlight = null;
        this._clickTargets.clear();
    }

    public void addAnnotation(Annotation annotation) {
        this._annotations.add(annotation);
    }

    Point convertToRegionLocation(Point point) {
        Point point2 = new Point(point);
        point2.translate(-this._region.x, -this._region.y);
        return point2;
    }

    public void addArrow(Point point, Point point2) {
        Point point3 = this.convertToRegionLocation(point);
        Point point4 = this.convertToRegionLocation(point2);
        this.addAnnotation(new AnnotationArrow(point3, point4, Color.black));
    }

    public void addCircle(Region region) {
        Location location = region.getCenter();
        Location location2 = region.getTopLeft();
        location.translate(-this._region.x, -this._region.y);
        location2.translate(-this._region.x, -this._region.y);
        location2.translate((int)((double)(location2.x - location.x) * 0.44), (int)((double)(location2.y - location.y) * 0.44));
        this.addAnnotation(new AnnotationOval(location.x, location.y, location2.x, location2.y));
    }

    public void addHighlight(Region region) {
        Rectangle rectangle = new Rectangle(region.getRect());
        rectangle.translate(-this._region.x, -this._region.y);
        this.addAnnotation(new AnnotationHighlight(rectangle));
    }

    public void addRectangle(Region region) {
        Rectangle rectangle = new Rectangle(region.getRect());
        rectangle.translate(-this._region.x, -this._region.y);
        this.addAnnotation(new AnnotationRectangle(rectangle));
    }

    public void addClickTarget(Region region, String string) {
        this._clickTargets.add(new ClickTarget((Object)this, region.getRect(), string));
    }

    public void addToolTip(Location location, String string) {
        Point point = this.convertToRegionLocation((Point)location);
        this.addAnnotation(new AnnotationToolTip(string, point));
    }

    public void addText(Location location, String string) {
        this.addText(location, string, HorizontalAlignment.LEFT, VerticalAlignment.TOP);
    }

    public void addComponent(Component component) {
        this.content.add(component);
    }

    public void addBookmark(Location location, String string) {
        Flag flag = new Flag(location, string);
        this.content.add(flag);
    }

    public void addSpotlight(Region region) {
        this.spotlight = new Spotlight(this, region);
    }

    public void addText(Location location, String string, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        StaticText staticText = new StaticText(string);
        staticText.align(location, horizontalAlignment, verticalAlignment);
        staticText.moveInside(this._region);
        this.content.add(staticText);
        this.repaint();
    }

    public void addText(Region region, String string, Side side) {
        HorizontalAlignment horizontalAlignment = null;
        VerticalAlignment verticalAlignment = null;
        Location location = null;
        if (side == Side.TOP) {
            location = new Location(region.x + region.w / 2, region.y);
            horizontalAlignment = HorizontalAlignment.CENTER;
            verticalAlignment = VerticalAlignment.BOTTOM;
        } else if (side == Side.BOTTOM) {
            location = new Location(region.x + region.w / 2, region.y + region.h);
            horizontalAlignment = HorizontalAlignment.CENTER;
            verticalAlignment = VerticalAlignment.TOP;
        } else if (side == Side.LEFT) {
            location = new Location(region.x, region.y + region.h / 2);
            horizontalAlignment = HorizontalAlignment.RIGHT;
            verticalAlignment = VerticalAlignment.MIDDLE;
        } else if (side == Side.RIGHT) {
            location = new Location(region.x + region.w, region.y + region.h / 2);
            horizontalAlignment = HorizontalAlignment.LEFT;
            verticalAlignment = VerticalAlignment.MIDDLE;
        }
        this.addText(location, string, horizontalAlignment, verticalAlignment);
    }

    public void addDialog(String string, int n) {
        this.dialog = new NavigationDialog((Object)this, string, n);
        this.dialog.setAlwaysOnTop(true);
        this.dialog.pack();
    }

    public void addDialog(String string) {
        this.addDialog(string, 4);
        this.dialog.setLocationRelativeTo((Component)((Object)this));
    }

    public void addDialog(NavigationDialog navigationDialog) {
        this.dialog = navigationDialog;
        this.dialog.setAlwaysOnTop(true);
        this.dialog.pack();
    }

    public ClickTarget getLastClickedTarget() {
        return this._lastClickedTarget;
    }

    public void setLastClickedTarget(ClickTarget clickTarget) {
        this._lastClickedTarget = clickTarget;
    }

    public String showNowWithDialog(int n) {
        if (this.dialog == null) {
            this.addDialog("", n);
            this.dialog.setLocationRelativeTo((Component)((Object)this));
        } else {
            this.dialog.setStyle(n);
        }
        return this.showNow();
    }

    public String showNow() {
        return this.showNow(10.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String showNow(float f) {
        this.setVisible(true);
        this.toFront();
        if (this.spotlight != null) {
            for (ClickTarget object : this._clickTargets) {
                object.setVisible(true);
                object.setIgnoreMouse(true);
            }
            String string = this.spotlight.waitUserAction();
            for (ClickTarget clickTarget : this._clickTargets) {
                clickTarget.dispose();
            }
            this.closeNow();
            this.focusBelow();
            return string;
        }
        if (this.dialog != null) {
            for (ClickTarget interruptedException : this._clickTargets) {
                interruptedException.setVisible(true);
                interruptedException.setIgnoreMouse(true);
            }
            this.dialog.setVisible(true);
            Object object = this;
            synchronized (object) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException clickTarget) {
                    clickTarget.printStackTrace();
                }
            }
            for (ClickTarget clickTarget : this._clickTargets) {
                clickTarget.dispose();
            }
            this.dialog.dispose();
            object = this.dialog.getActionCommand();
            this.closeNow();
            this.focusBelow();
            return object;
        }
        if (!this._clickTargets.isEmpty()) {
            for (ClickTarget clickTarget : this._clickTargets) {
                clickTarget.setVisible(true);
            }
            SikuliGuide sikuliGuide = this;
            synchronized (sikuliGuide) {
                try {
                    ((Object)((Object)this)).wait();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            for (ClickTarget clickTarget : this._clickTargets) {
                clickTarget.dispose();
            }
            Debug.log((String)("Last clicked:" + this._lastClickedTarget.getName()), (Object[])new Object[0]);
            this.closeNow();
            this.focusBelow();
            this.robot.mousePress(16);
            this.robot.mouseRelease(16);
            return "Next";
        }
        this.closeAfter(f);
        return "Next";
    }

    private void closeNow() {
        this.clear();
        this.setVisible(false);
        this.dispose();
    }

    private void closeAfter(float f) {
        try {
            Thread.sleep((int)f * 1000);
        }
        catch (InterruptedException interruptedException) {
            this.closeNow();
            interruptedException.printStackTrace();
        }
        this.closeNow();
    }

    public void focusBelow() {
        if (Env.getOS() == OS.MAC) {
            this.robot.keyPress(157);
            this.robot.keyPress(9);
            this.robot.keyRelease(157);
            this.robot.keyRelease(9);
            this.robot.delay(1000);
        }
    }

    public void toFront() {
        if (Env.getOS() == OS.MAC) {
            Env.getOSUtil().bringWindowToFront((JWindow)((Object)this), true);
        }
        super.toFront();
    }

    public static enum Side {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;

    }

    class StaticText
    extends JLabel {
        static final String style = "font-size:16px;color:white;background-color:#333333;padding:3px";
        String raw_text;

        StaticText(String string) {
            this.raw_text = string;
            String string2 = "<html><div style='font-size:16px;color:white;background-color:#333333;padding:3px'>" + this.raw_text + "</div></html>";
            this.setText(string2);
            this.setMaximumWidth(300);
            this.setSize(this.getPreferredSize());
        }

        void setMaximumWidth(int n) {
            Dimension dimension = this.getPreferredSize();
            if (dimension.width > n) {
                String string = "<html><div style='width:" + n + ";" + style + "'>" + this.raw_text + "</div></html>";
                this.setText(string);
            }
        }

        void moveInside(Region region) {
            int n;
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            int n2 = point.x;
            int n3 = point.y;
            Screen screen = region.getScreen();
            Location location = screen.getBottomRight();
            Location location2 = region.getBottomRight();
            int n4 = n2 + dimension.width - Math.min(location.x, location2.x);
            if (n4 > 0) {
                n2 -= n4;
                n2 -= 5;
            }
            if ((n = n3 + dimension.height - Math.min(location.y, location2.y)) > 0) {
                n3 -= n;
                n3 -= 5;
            }
            this.setBounds(n2 -= SikuliGuide.this._region.x, n3 -= SikuliGuide.this._region.y, dimension.width, dimension.height);
        }

        public void align(Location location, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
            this.setLocation((Point)location);
            Dimension dimension = this.getSize();
            if (horizontalAlignment == HorizontalAlignment.CENTER) {
                location.x -= dimension.width / 2;
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                location.x -= dimension.width;
            }
            if (verticalAlignment == VerticalAlignment.MIDDLE) {
                location.y -= dimension.height / 2;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                location.y -= dimension.height;
            }
            this.setLocation((Point)location);
        }
    }

    public static enum HorizontalAlignment {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static enum VerticalAlignment {
        TOP,
        MIDDLE,
        BOTTOM;

    }
}

