/*
 * snmptest2.C: Test example program 2 for snmpkit
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later 
 * version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the 
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 *
 * See the AUTHORS file for a list of people who have hacked on 
 * this code. 
 * See the ChangeLog file for a list of changes.
 *
 */

#include <snmpkit>

#include <string.h>
#include <iostream.h>

static const char SYSDESC[]="1.3.6.1.2.1.1.1.0";

struct PrinterInfo{
  char *sysDesc;
};

void printer_info_insert_sysDesc(void *dest_ptr,const char *str){
  PrinterInfo *dest=reinterpret_cast<PrinterInfo*>(dest_ptr);
  dest->sysDesc=strdup(str);
}

void *do_req(SNMP_session *printer){
  PrinterInfo prinfo;
  try{
    cerr << printer->Hostname() << endl << flush;
    printer->setDebug();
    SNMP_structFiller table(*printer);
    table.append_string(SYSDESC,printer_info_insert_sysDesc);
    table.get(&prinfo);
    cout << printer->Hostname() << ' ' << prinfo.sysDesc << endl;
    return NULL;
  }catch(SNMPNoResponseException e){ // this is not a problem
    return NULL;
  }catch(ProgrammerException e){
    cerr << "inside programmer error\n";
  }catch(DecodeException e){
    cerr << "inside decode error\n";
  }catch(SNMPException e){
    cerr << "inside SNMPException\n";
  }catch(...){
    cerr << "inside other error\n";
  }
  int *i=new int;
  *i=1;
  return i;
}

int main(int argc, char **argv){
  if(argc!=2)
    exit(2);
  set_snmpsock_props(1,3);
  std::list<SNMP_session*> sessions;
  try{
    std::string hostspec(argv[1]);
    SNMP_sessions(sessions,hostspec,do_req);
    SNMP_sessions_done();
  }catch(ProgrammerException e){
    cerr << "programmer error\n";
  }catch(DecodeException e){
    cerr << "decode error\n";
  }catch(...){
    cerr << "other error\n";
  }
  exit(1);
}  

