use ui;
use core:geometry;
use core:io;
use graphics;
use core:debug;

class LayerPainter extends Painter {
	SolidBrush red;
	SolidBrush green;
	SolidBrush blue;

	SolidBrush redA;
	SolidBrush greenA;
	SolidBrush blueA;

	init() {
		init() {
			redA = red.withAlpha(0.5);
			greenA = green.withAlpha(0.5);
			blueA = blue.withAlpha(0.5);
			red = red;
			green = green;
			blue = blue;
		}

		bgColor = black;
	}

	Bool render(Size s, Graphics g) {
		g.fill(Rect(200, 0, 400, 400), blue);

		g.transform(rotate(45 deg, Point(200, 200)));
		g.push(Rect(100, 100, 300, 300), 0.7);
		g.transform(rotate(10 deg, Point(200, 200)));

		g.fill(Rect(100, 100, 300, 300), greenA);
		g.fillOval(Rect(80, 80, 320, 320), redA);
		g.fillOval(Rect(150, 150, 250, 250), red);

		g.pop();

		g.transform(rotate(-20 deg, Point(200, 200)));
		g.push(Rect(100, 100, 200, 200));

		g.fill(Rect(0, 0, 400, 400), blue);

		g.pop();

		false;
	}

}

class LayerWin extends Frame {
	init() {
		init("Layers!") {}
		size(Size(400, 400));
		painter(LayerPainter());
		create();
	}
}

void layer() {
	LayerWin win;
	win.closeLater();
	win.waitForClose();
}
