use ui;
use graphics;
use core:geometry;
use core:lang;
use lang:bs:macro;

/**
 * Data for global variables.
 */
class Globals extends Composite {
	init(GlobalVar[] globals) {
		init(null) {}

		for (v in globals) {
			source << Global(v);
		}

		// Make the order consistent.
		source.sort((a, b) => a.name < b.name);

		// // Add them.
		// for (v in g) {
		// 	parts << Part(v.name, 0, GlobalPtr(v.type, v.src), false);
		// }
	}

	// Copy.
	init(Globals original) {
		init(original) {}
	}

	// Source data for globals.
	private value Global {
		GlobalVar named;
		Str name;
		TypeInfo type;
		unsafe:RawPtr src;

		init(GlobalVar v) {
			// Extract data here to make it quicker to update everything later on.
			init {
				named = v;
				name = v.name;
				type = fromValue(v.type);
				src = unsafe:RawPtr:fromGlobal(v);
			}
		}
	}

	// Source data.
	private Global[] source;

	// Update.
	void update(World:Traversal t, unsafe:RawPtr object, Nat offset) : override {
		Nat count = source.count;

		if (parts.count != count) {
			parts.clear();
			parts.reserve(source.count);
			for (s in source) {
				parts << Part(s.name, 0, t.create(s.named, s.type), true);
			}
		}

		for (Nat i = 0; i < count; i++) {
			var val = parts[i].value;
			var src = source[i].src;

			t.addData(src, val);
			val.update(t, src, 0);
		}
	}

	// Traverse.
	void traverse(World:Traversal t, unsafe:RawPtr object, Nat offset) : override {
		// Note: At this point we should have resized parts to match source. If not, we either
		// update too few elements, or we throw an exception. Both are fine, as none cause a crash.
		for (i, p in parts) {
			p.value.traverse(t, source[i].src, 0);
		}
	}

	// Title.
	Str title(World world) : override {
		"Globals";
	}

	// Copy.
	protected Data copyObject() : override {
		Globals(this);
	}
}
