; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mcpu=pwr8 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P8-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr9 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P9-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr10 \
; RUN:   -mtriple=powerpc64-unknown-aix < %s | FileCheck %s --check-prefix=P10-BE
; RUN: llc -verify-machineinstrs -mcpu=pwr8 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P8-LE
; RUN: llc -verify-machineinstrs -mcpu=pwr9 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P9-LE
; RUN: llc -verify-machineinstrs -mcpu=pwr10 \
; RUN:   -mtriple=powerpc64le-unknown-unknown < %s | FileCheck %s --check-prefix=P10-LE

define dso_local void @foo1(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo1:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C0(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    li 4, 3333
; P8-BE-NEXT:    sth 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo1:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C0(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    li 4, 3333
; P9-BE-NEXT:    sth 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo1:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltiw 0, 218434821
; P10-BE-NEXT:    li 4, 3333
; P10-BE-NEXT:    sth 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo1:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI0_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI0_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    li 4, 3333
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    sth 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo1:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI0_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI0_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    li 4, 3333
; P9-LE-NEXT:    sth 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo1:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltiw 0, 218434821
; P10-LE-NEXT:    li 4, 3333
; P10-LE-NEXT:    sth 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 3333, ptr %arrayidx8, align 2
  ret void
}

define dso_local void @foo2(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo2:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C1(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 3333
; P8-BE-NEXT:    ori 4, 4, 3333
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo2:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C1(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 3333
; P9-BE-NEXT:    ori 4, 4, 3333
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo2:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltiw 0, 218434821
; P10-BE-NEXT:    pli 4, 218434821
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo2:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI1_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI1_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 3333
; P8-LE-NEXT:    ori 4, 4, 3333
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo2:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI1_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI1_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 3333
; P9-LE-NEXT:    ori 4, 4, 3333
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo2:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltiw 0, 218434821
; P10-LE-NEXT:    pli 4, 218434821
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 3333, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 3333, ptr %arrayidx9, align 2
  ret void
}

define dso_local void @foo3(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo3:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C2(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 3333
; P8-BE-NEXT:    ori 4, 4, 3333
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    li 4, 3333
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    sth 4, 20(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo3:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C2(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 3333
; P9-BE-NEXT:    ori 4, 4, 3333
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    li 4, 3333
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    sth 4, 20(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo3:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 218434821
; P10-BE-NEXT:    xxspltiw 0, 218434821
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    li 4, 3333
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    sth 4, 20(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo3:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI2_0@toc@ha
; P8-LE-NEXT:    li 5, 3333
; P8-LE-NEXT:    addi 4, 4, .LCPI2_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 3333
; P8-LE-NEXT:    ori 4, 4, 3333
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    sth 5, 20(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo3:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI2_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI2_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 3333
; P9-LE-NEXT:    ori 4, 4, 3333
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    li 4, 3333
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    sth 4, 20(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo3:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 218434821
; P10-LE-NEXT:    xxspltiw 0, 218434821
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    li 4, 3333
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    sth 4, 20(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 3333, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 3333, ptr %arrayidx9, align 2
  %arrayidx10 = getelementptr inbounds i16, ptr %a, i64 10
  store i16 3333, ptr %arrayidx10, align 2
  ret void
}

define dso_local void @foo4(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo4:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C3(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 3333
; P8-BE-NEXT:    ori 4, 4, 3333
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo4:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C3(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 3333
; P9-BE-NEXT:    ori 4, 4, 3333
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo4:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 218434821
; P10-BE-NEXT:    xxspltiw 0, 218434821
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    std 4, 16(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo4:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI3_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI3_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 3333
; P8-LE-NEXT:    ori 4, 4, 3333
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo4:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI3_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI3_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 3333
; P9-LE-NEXT:    ori 4, 4, 3333
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo4:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 218434821
; P10-LE-NEXT:    xxspltiw 0, 218434821
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    std 4, 16(3)
; P10-LE-NEXT:    blr
entry:
  store <8 x i16> <i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333, i16 3333>, ptr %a, align 2
  %arrayidx8 = getelementptr inbounds i16, ptr %a, i64 8
  store i16 3333, ptr %arrayidx8, align 2
  %arrayidx9 = getelementptr inbounds i16, ptr %a, i64 9
  store i16 3333, ptr %arrayidx9, align 2
  %arrayidx10 = getelementptr inbounds i16, ptr %a, i64 10
  store i16 3333, ptr %arrayidx10, align 2
  %arrayidx11 = getelementptr inbounds i16, ptr %a, i64 11
  store i16 3333, ptr %arrayidx11, align 2
  ret void
}

define dso_local void @foo5(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo5:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C4(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 5
; P8-BE-NEXT:    ori 4, 4, 5653
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo5:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C4(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 5
; P9-BE-NEXT:    ori 4, 4, 5653
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo5:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltiw 0, 333333
; P10-BE-NEXT:    pli 4, 333333
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo5:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI4_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI4_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 5
; P8-LE-NEXT:    ori 4, 4, 5653
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo5:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI4_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI4_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 5
; P9-LE-NEXT:    ori 4, 4, 5653
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo5:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltiw 0, 333333
; P10-LE-NEXT:    pli 4, 333333
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 333333, i32 333333, i32 333333, i32 333333>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 333333, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo6(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo6:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C5(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 5
; P8-BE-NEXT:    ori 4, 4, 5653
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo6:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C5(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 5
; P9-BE-NEXT:    ori 4, 4, 5653
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo6:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 333333
; P10-BE-NEXT:    xxspltiw 0, 333333
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    std 4, 16(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo6:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI5_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI5_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 5
; P8-LE-NEXT:    ori 4, 4, 5653
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo6:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI5_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI5_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 5
; P9-LE-NEXT:    ori 4, 4, 5653
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo6:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 333333
; P10-LE-NEXT:    xxspltiw 0, 333333
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    std 4, 16(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x i32> <i32 333333, i32 333333, i32 333333, i32 333333>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds i32, ptr %a, i64 4
  store i32 333333, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds i32, ptr %a, i64 5
  store i32 333333, ptr %arrayidx5, align 4
  ret void
}

define dso_local void @foo7(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo7:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C6(2) # %const.0
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    lis 4, 508
; P8-BE-NEXT:    ori 4, 4, 41045
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo7:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C6(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 508
; P9-BE-NEXT:    ori 4, 4, 41045
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo7:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxlxor 0, 0, 0
; P10-BE-NEXT:    pli 4, 33333333
; P10-BE-NEXT:    xxsplti32dx 0, 1, 33333333
; P10-BE-NEXT:    std 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo7:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI6_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI6_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 508
; P8-LE-NEXT:    ori 4, 4, 41045
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo7:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI6_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI6_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 508
; P9-LE-NEXT:    ori 4, 4, 41045
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo7:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxlxor 0, 0, 0
; P10-LE-NEXT:    pli 4, 33333333
; P10-LE-NEXT:    xxsplti32dx 0, 1, 33333333
; P10-LE-NEXT:    std 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x i64> <i64 33333333, i64 33333333>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds i64, ptr %a, i64 2
  store i64 33333333, ptr %arrayidx2, align 8
  ret void
}

define dso_local void @foo8(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo8:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C7(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 16469
; P8-BE-NEXT:    ori 4, 4, 7864
; P8-BE-NEXT:    stw 4, 16(3)
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo8:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C7(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16469
; P9-BE-NEXT:    ori 4, 4, 7864
; P9-BE-NEXT:    stw 4, 16(3)
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo8:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxspltiw 0, 1079320248
; P10-BE-NEXT:    pli 4, 1079320248
; P10-BE-NEXT:    stw 4, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo8:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI7_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI7_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 16469
; P8-LE-NEXT:    ori 4, 4, 7864
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    stw 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo8:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI7_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI7_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16469
; P9-LE-NEXT:    ori 4, 4, 7864
; P9-LE-NEXT:    stw 4, 16(3)
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo8:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxspltiw 0, 1079320248
; P10-LE-NEXT:    pli 4, 1079320248
; P10-LE-NEXT:    stw 4, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x float> <float 0x400AA3D700000000, float 0x400AA3D700000000, float 0x400AA3D700000000, float 0x400AA3D700000000>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds float, ptr %a, i64 4
  store float 0x400AA3D700000000, ptr %arrayidx4, align 4
  ret void
}

define dso_local void @foo9(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo9:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C8(2) # %const.0
; P8-BE-NEXT:    lis 5, 16394
; P8-BE-NEXT:    ori 5, 5, 41943
; P8-BE-NEXT:    lxvd2x 0, 0, 4
; P8-BE-NEXT:    rldic 4, 5, 32, 1
; P8-BE-NEXT:    oris 4, 4, 2621
; P8-BE-NEXT:    ori 4, 4, 28836
; P8-BE-NEXT:    stxvd2x 0, 0, 3
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo9:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C8(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16394
; P9-BE-NEXT:    ori 4, 4, 41943
; P9-BE-NEXT:    rldic 4, 4, 32, 1
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    oris 4, 4, 2621
; P9-BE-NEXT:    ori 4, 4, 28836
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo9:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    xxsplti32dx 0, 0, 1074439127
; P10-BE-NEXT:    pli 4, 1074439127
; P10-BE-NEXT:    pli 5, 171798692
; P10-BE-NEXT:    rldimi 5, 4, 32, 0
; P10-BE-NEXT:    xxsplti32dx 0, 1, 171798692
; P10-BE-NEXT:    std 5, 16(3)
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo9:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI8_0@toc@ha
; P8-LE-NEXT:    lis 5, 16394
; P8-LE-NEXT:    addi 4, 4, .LCPI8_0@toc@l
; P8-LE-NEXT:    ori 5, 5, 41943
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    rldic 4, 5, 32, 1
; P8-LE-NEXT:    oris 4, 4, 2621
; P8-LE-NEXT:    ori 4, 4, 28836
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo9:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI8_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI8_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16394
; P9-LE-NEXT:    ori 4, 4, 41943
; P9-LE-NEXT:    rldic 4, 4, 32, 1
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    oris 4, 4, 2621
; P9-LE-NEXT:    ori 4, 4, 28836
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo9:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    xxsplti32dx 0, 0, 1074439127
; P10-LE-NEXT:    pli 4, 1074439127
; P10-LE-NEXT:    pli 5, 171798692
; P10-LE-NEXT:    rldimi 5, 4, 32, 0
; P10-LE-NEXT:    xxsplti32dx 0, 1, 171798692
; P10-LE-NEXT:    std 5, 16(3)
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    blr
entry:
  store <2 x double> <double 3.330000e+00, double 3.330000e+00>, ptr %a, align 8
  %arrayidx2 = getelementptr inbounds double, ptr %a, i64 2
  store double 3.330000e+00, ptr %arrayidx2, align 8
  ret void
}

define dso_local void @foo10(ptr nocapture noundef writeonly %a) local_unnamed_addr {
; P8-BE-LABEL: foo10:
; P8-BE:       # %bb.0: # %entry
; P8-BE-NEXT:    ld 4, L..C9(2) # %const.0
; P8-BE-NEXT:    lxvw4x 0, 0, 4
; P8-BE-NEXT:    lis 4, 16469
; P8-BE-NEXT:    ori 4, 4, 7864
; P8-BE-NEXT:    rldimi 4, 4, 32, 0
; P8-BE-NEXT:    stxvw4x 0, 0, 3
; P8-BE-NEXT:    std 4, 16(3)
; P8-BE-NEXT:    blr
;
; P9-BE-LABEL: foo10:
; P9-BE:       # %bb.0: # %entry
; P9-BE-NEXT:    ld 4, L..C9(2) # %const.0
; P9-BE-NEXT:    lxv 0, 0(4)
; P9-BE-NEXT:    lis 4, 16469
; P9-BE-NEXT:    ori 4, 4, 7864
; P9-BE-NEXT:    rldimi 4, 4, 32, 0
; P9-BE-NEXT:    stxv 0, 0(3)
; P9-BE-NEXT:    std 4, 16(3)
; P9-BE-NEXT:    blr
;
; P10-BE-LABEL: foo10:
; P10-BE:       # %bb.0: # %entry
; P10-BE-NEXT:    pli 4, 1079320248
; P10-BE-NEXT:    xxspltiw 0, 1079320248
; P10-BE-NEXT:    rldimi 4, 4, 32, 0
; P10-BE-NEXT:    stxv 0, 0(3)
; P10-BE-NEXT:    std 4, 16(3)
; P10-BE-NEXT:    blr
;
; P8-LE-LABEL: foo10:
; P8-LE:       # %bb.0: # %entry
; P8-LE-NEXT:    addis 4, 2, .LCPI9_0@toc@ha
; P8-LE-NEXT:    addi 4, 4, .LCPI9_0@toc@l
; P8-LE-NEXT:    lxvd2x 0, 0, 4
; P8-LE-NEXT:    lis 4, 16469
; P8-LE-NEXT:    ori 4, 4, 7864
; P8-LE-NEXT:    rldimi 4, 4, 32, 0
; P8-LE-NEXT:    stxvd2x 0, 0, 3
; P8-LE-NEXT:    std 4, 16(3)
; P8-LE-NEXT:    blr
;
; P9-LE-LABEL: foo10:
; P9-LE:       # %bb.0: # %entry
; P9-LE-NEXT:    addis 4, 2, .LCPI9_0@toc@ha
; P9-LE-NEXT:    addi 4, 4, .LCPI9_0@toc@l
; P9-LE-NEXT:    lxv 0, 0(4)
; P9-LE-NEXT:    lis 4, 16469
; P9-LE-NEXT:    ori 4, 4, 7864
; P9-LE-NEXT:    rldimi 4, 4, 32, 0
; P9-LE-NEXT:    stxv 0, 0(3)
; P9-LE-NEXT:    std 4, 16(3)
; P9-LE-NEXT:    blr
;
; P10-LE-LABEL: foo10:
; P10-LE:       # %bb.0: # %entry
; P10-LE-NEXT:    pli 4, 1079320248
; P10-LE-NEXT:    xxspltiw 0, 1079320248
; P10-LE-NEXT:    rldimi 4, 4, 32, 0
; P10-LE-NEXT:    stxv 0, 0(3)
; P10-LE-NEXT:    std 4, 16(3)
; P10-LE-NEXT:    blr
entry:
  store <4 x float> <float 0x400AA3D700000000, float 0x400AA3D700000000, float 0x400AA3D700000000, float 0x400AA3D700000000>, ptr %a, align 4
  %arrayidx4 = getelementptr inbounds float, ptr %a, i64 4
  store float 0x400AA3D700000000, ptr %arrayidx4, align 4
  %arrayidx5 = getelementptr inbounds float, ptr %a, i64 5
  store float 0x400AA3D700000000, ptr %arrayidx5, align 4
  ret void
}
