#include <SyFi.h>
#include <fstream>


using namespace GiNaC; 
using namespace SyFi; 
using namespace std; 


int main() {

    initSyFi(3); 

    ex p0 = lst(0.0,0.0,0.0);
    ex p1 = lst(1.0,1.0,1.0);

    Line line(p0,p1);

    // show usage of repr 
    symbol t("t"); 
    ex l_repr = line.repr(t);
    cout <<"l.repr "<<l_repr<<endl; 


    for (unsigned int i=0; i< l_repr.nops(); i++) {
        cout <<"l_repr.op(" <<i<<"):  "<<l_repr.op(i)<<endl; 
    }

    // compute the integral of a function along the line 
    ex f = x*x + y*y*y + z;
    ex intf = line.integrate(f); 
    cout <<"intf "<<intf<<endl; 


    // regression test
    archive ar; 
    ar.archive_ex(l_repr, "l_repr"); 
    ar.archive_ex(intf, "intf"); 

    ofstream vfile("line_ex1.gar.v"); 
    vfile << ar; vfile.close(); 
    if(!compare_archives("line_ex1.gar.v", "line_ex1.gar.r")) { 
	    cerr << "Failure!" << endl;
	    return -1;
    }

    return 0; 

}

