--[[
Copyright (C) 2013-2014 Draios inc.
 
This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 as
published by the Free Software Foundation.


This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
--]]

view_info = 
{
	id = "docker_events",
	name = "Docker Events",
	description = "Lists all the events generated by docker activity, for example container start, stop, kill, etc.",
	tags = {"Default", "nocsysdig"},
	view_type = "list",
	applies_to = {""},
	filter = "evt.type=infra",
	use_defaults = true,
	columns = 
	{
		{
			name = "TIME",
			field = "evt.time",
			description = "Time when the event happened.",
			colsize = 18,
		},
		{
			name = "EVENT TYPE",
			field = "evt.arg.name",
			description = "Type of docker event.",
			colsize = 20,
		},
		{
			name = "CONTAINER ID",
			field = "evt.infra.docker.container.id",
			description = "ID of the container that generated this event.",
			colsize = 20,
		},
		{
			name = "CONTAINER IMAGE",
			field = "evt.infra.docker.container.image",
			description = "Image name of the container that generated this event.",
			colsize = 20,
		},
		{
			name = "CONTAINER NAME",
			field = "evt.infra.docker.container.name",
			description = "Name of the container that generated this event.",
			colsize = 0,
		},
	}
}
