/* twpsk  - A gui application for PSK
 * Copyright (C) 1999-2006 Ted Williams WA0EIR 
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be
 * useful, but WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 * USA.
 *
 * Version: 3.0 - Jul 2008
 */

#include "decoderWids.h"

extern Wids pskwids;
extern TwpskCB twpskCB;
extern Position winlocs[3][2];
extern DecoderWid decoderwids;
extern Position xb, yb;
#if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
extern Pixmap pixmap;
#endif


static void closeProc(Widget w, XtPointer clientdata, XtPointer /*calldata*/ ) 
{
   DecoderWid *dec = (DecoderWid *)clientdata;

   commControl(dec->commChannel, COMM_MODE, MO_DISABLED); // close channel

   XtPopdown( dec->getMainWid() );
   dec->visible = 0;
}


/* Scope redraw callback */
static void decScopeCB (Widget /*w*/, XtPointer cdata, XtPointer /*cbs*/) 
{ 
   ((DecoderWid *)cdata)->getScope().drawcirc();
}


/* QPSK selection changed callback */
static void decQpskCB (Widget /*w*/, XtPointer cdata, XtPointer cbs)
{
   XmToggleButtonCallbackStruct *ptr = (XmToggleButtonCallbackStruct *) cbs;
   commControl(((DecoderWid *)cdata)->commChannel, COMM_QPSK, ptr->set);
}


/* AFC selection changed callback */
static void decAfcCB (Widget /*w*/, XtPointer cdata, XtPointer cbs)
{
   XmToggleButtonCallbackStruct *ptr = (XmToggleButtonCallbackStruct *) cbs;
   commControl(((DecoderWid *)cdata)->commChannel, COMM_AFC, ptr->set);
}


/* Up/Down-Arrow callback */
static void decArrowCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   DecoderWid *dec = (DecoderWid *)cdata;
   float freq, delta;
   String str;
   unsigned char direction;
   XmArrowButtonCallbackStruct *cbsPtr = (XmArrowButtonCallbackStruct *)cbs;
   XButtonPressedEvent *event = (XButtonPressedEvent *) cbsPtr->event;

   XtVaGetValues (w, XmNarrowDirection, &direction, NULL);

   if (event->state & ShiftMask)            /* if shifted click */
      delta = 8.0;                          /* change by 8 */
   else 
      delta = 1.0;                          /* else change by 1 */
   if (cbsPtr->click_count == 2)            /* if double click, changes by 7 */
      delta = 7.0;                          /* cuz already been changed by 1 */

   XtVaGetValues (dec->rx2FreqText,         /* Get the freq */
      XmNvalue, &str,
      NULL);

   freq = atof(str);                        /* convert to a float */

   if (direction == XmARROW_UP)
      freq = freq + delta;
   else
      freq = freq - delta;
      
   sprintf (str, "%4.1f", freq);            /* float to a string */
   
   XmTextFieldSetString (dec->rx2FreqText, str);

   /* set new freq in rx class */
   commControl(dec->commChannel, COMM_FREQ, (int)(freq*100));
}


/* callback to "exchange secondary and main windows" */
static void swapCB (Widget w, XtPointer cdata, XtPointer cbs)
{
   extern Pixel lightBG;

   Boolean mainval, otherval;
   DecoderWid *dec = (DecoderWid *)cdata;
   XmTextPosition lastPos;

   /* exchange low level psk31_receiver objects */
   commControl(COMM_RXCH, COMM_SWAP, dec->commChannel);

   /* following setXXX functions invoke a commControl request
    * to set the values on the corresponding psk31_receiver object.
    * this is unnecessary as those objects have been swap, but it
    * doesn't do any harm...
    */

   /* exchange Text */
   char *mainstr, *otherstr;
   Widget mainText = pskwids.getRxText();
   Widget secText = dec->getTextWid();

   otherstr = (char*)XmTextGetString (secText);
   mainstr = (char*)XmTextGetString(mainText);

   XmTextDisableRedisplay (mainText);
   XmTextDisableRedisplay (secText);

   XmTextSetString (secText, mainstr);
   XmTextSetString (mainText, otherstr);

   XtFree(otherstr);
   XtFree(mainstr);

   XmTextEnableRedisplay (mainText);
   XmTextEnableRedisplay (secText);

   lastPos = XmTextGetLastPosition (secText);
   XmTextShowPosition (secText, lastPos);
   XmTextSetInsertionPosition (secText, lastPos);

   lastPos = XmTextGetLastPosition (mainText);
   XmTextShowPosition (mainText, lastPos);
   XmTextSetInsertionPosition (mainText, lastPos);

   /* clear any scrolling operations */
   pskwids.setRxScrollFlag (!SCROLLING);
   dec->setRxScrollFlag (!SCROLLING);

   XtVaSetValues (mainText,
      XmNbackground, lightBG,
      NULL);

   XtVaSetValues (secText ,
      XmNbackground, lightBG,
      NULL);

   /* exchange QPSK button */
   mainval = pskwids.getQPSK(); otherval = dec->getQPSK(); 
   pskwids.setQPSK(otherval); dec->setQPSK(mainval);

   /* exchange AFC button */
   mainval = pskwids.getAFC(); otherval = dec->getAFC(); 
   pskwids.setAFC(otherval); dec->setAFC(mainval);

   /* exchange frequency */
   float mainf, otherf;
   mainf = pskwids.getFreq(); otherf = dec->getFreq(); 
   pskwids.setFreq(otherf); dec->setFreq(mainf);
}


Widget DecoderWid::shell;


void DecoderWid::updateDisplay(float freq, int DCD, int IMD)
{
   if( hasfocus==0 && fabs(freq-curfreq)>0.05 )
   {
      curfreq = freq;
      sprintf(str, "%4.1f", freq);
      XmTextFieldSetString (rx2FreqText, str);
   }
   XtVaSetValues(DCDwid, XmNset, DCD?1:0, NULL);
}


void DecoderWid::move(int x, int y)
{
   XtVaSetValues(dialogShell, XmNx, x, XmNy, y, NULL);
}


void DecoderWid::buildWidgets(Widget shell, AppRes *appRes, int chan)
{
   Dimension height, width;
   rxScrollFlag = 0;
   char title[24] = "TWPSK Secondary RX ";
   char num[4];

   ch = chan;
   sprintf (num, "%d", chan + 1);
   strcat (title, num);

   dialogShell =
      XtVaCreateWidget ("secondaryDiag", xmDialogShellWidgetClass, shell,
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      XmNtitle, title,
      NULL);

#if (MAKE_ICON == 1) && (HAVE_X11_XPM_H == 1) && (HAVE_LIBXPM == 1)
   XtVaSetValues (XtParent (dialogShell),
      XmNiconPixmap, pixmap,
      NULL);
#endif

   mainForm = XtVaCreateWidget("mainForm", xmFormWidgetClass, 
      dialogShell, 
      XmNverticalSpacing, SPACE_B,
      XmNhorizontalSpacing, SPACE_B,
      XmNdialogStyle, XmDIALOG_MODELESS,
      NULL);

   bottomForm = XtVaCreateWidget ("bottomForm", xmFormWidgetClass, mainForm,
      XmNhorizontalSpacing, SPACE_B,
      XmNverticalSpacing, SPACE_B,
      XmNtopAttachment, XmATTACH_NONE,
      XmNtopOffset, 0,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNbottomOffset, 0,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   frame1 = XtVaCreateWidget ("frame1", xmFrameWidgetClass, bottomForm,
      XmNshadowThickness, 3,
XmNmarginWidth, SPACE_A,
XmNmarginHeight, SPACE_A,
      XmNshadowType, XmSHADOW_OUT,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   dscope.scope_width = SCOPE_HEIGHT;
   dscope.border_width = 2;

   scopeDA = XtVaCreateManagedWidget ("scopeDA", xmDrawingAreaWidgetClass,
      frame1,
      XmNheight, dscope.scope_width,
      XmNwidth, dscope.scope_width,
      NULL);

   frame2 = XtVaCreateWidget ("frame2", xmFrameWidgetClass, bottomForm,
      XmNshadowThickness, 3,
//      XmNmarginWidth, SPACE_B,
//      XmNmarginHeight, SPACE_B,
      XmNshadowType, XmSHADOW_OUT,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, frame1,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   centerForm = XtVaCreateWidget ("centerForm", xmFormWidgetClass, frame2,
      XmNhorizontalSpacing, SPACE_B,
      XmNverticalSpacing, SPACE_B,
      NULL);

   rxLabel = XtVaCreateManagedWidget ("Rx Freq", xmLabelWidgetClass,
      centerForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   frame2a = XtVaCreateWidget ("frame2a", xmFrameWidgetClass, centerForm,
      XmNshadowThickness, 2,
      XmNmarginWidth, SPACE_A,
      XmNmarginHeight, SPACE_A,
      XmNshadowType, XmSHADOW_ETCHED_IN,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, rxLabel,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   rxFreqCombo = XtVaCreateWidget("rxFreqCombo", xmFormWidgetClass, frame2a,
      XmNverticalSpacing, SPACE_A,
      XmNhorizontalSpacing, SPACE_A,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, frame1,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   strcpy(str,"1000.0");
   rx2FreqText = XtVaCreateManagedWidget ("rx2FreqText", xmTextFieldWidgetClass,
      rxFreqCombo,
      XmNshadowThickness, 0,
      XmNmaxLength, 6,
      XmNcolumns, 6,
      XmNmarginHeight, 10,
      XmNvalue, str,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /* up arrow for rx freq */
   rxUpArrow = XtVaCreateManagedWidget ("rxUpArrow", xmArrowButtonWidgetClass,
      rxFreqCombo,
      XmNshadowThickness, 0,
      XmNwidth, ARROW_WIDTH,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_POSITION,
      XmNbottomPosition, 50,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, rx2FreqText,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   /* down arrow for rx freq */
   rxDownArrow = XtVaCreateManagedWidget ("rxUpArrow", xmArrowButtonWidgetClass,
      rxFreqCombo,
      XmNshadowThickness, 0,
      XmNwidth, ARROW_WIDTH,
      XmNarrowDirection, XmARROW_DOWN,
      XmNtopAttachment, XmATTACH_POSITION,
      XmNtopPosition, 50,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, rx2FreqText,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   AFCwid = XtVaCreateManagedWidget ("AFC", xmToggleButtonWidgetClass,
      rxFreqCombo,
      XmNshadowThickness, 0,
      XmNset, True,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, rxDownArrow,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   pbForm = XtVaCreateWidget("pbForm", xmFormWidgetClass, centerForm,
     XmNhorizontalSpacing, SPACE_A,
     XmNverticalSpacing, SPACE_A,
//      XmNtopOffset, 2 * SPACE_B,
//      XmNbottomOffset, SPACE_B,
//      XmNleftOffset, SPACE_B,
//      XmNrightOffset, SPACE_B,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, rxFreqCombo,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNleftWidget, rxFreqCombo,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   swapBtn = XtVaCreateManagedWidget ("<-> Main", xmPushButtonWidgetClass,
      pbForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_POSITION,
      XmNrightPosition, 45,
      NULL);

   closeBtn = XtVaCreateManagedWidget("Close", xmPushButtonWidgetClass, pbForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_POSITION,
      XmNleftPosition, 55,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);


   /* rx scrolled Window */
   rxTextSW = XtVaCreateWidget ("rxTextSW", xmScrolledWindowWidgetClass,
      mainForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, bottomForm,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /* rx text widget */
   rxText = XtVaCreateManagedWidget ("rxText", xmTextWidgetClass, rxTextSW,
      XmNrows, 4,
      XmNeditMode, XmMULTI_LINE_EDIT,
      XmNeditable, False,
      XmNwordWrap, True,
      XmNcursorPositionVisible, False,
      XmNautoShowCursorPosition, False,
      XmNscrollHorizontal, False,
      XmNshadowThickness, 2,
      XmNuserData, (XtPointer)this,
      NULL);

   /* get the scrollbar widget id */
   XtVaGetValues (rxTextSW,
      XmNverticalScrollBar, &rxScrollBar,
      NULL);

   XtVaSetValues (rxScrollBar,
      XmNuserData, this,
      NULL);

   frame3 = XtVaCreateWidget ("frame3", xmFrameWidgetClass, bottomForm,
      XmNshadowThickness, 3,
      XmNmarginWidth, SPACE_A,
      XmNmarginHeight, SPACE_A,
      XmNshadowType, XmSHADOW_OUT,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_WIDGET,
      XmNleftWidget, frame2,
      XmNrightAttachment, XmATTACH_NONE,
      NULL);

   modeForm = XtVaCreateManagedWidget ("modeForm", xmFormWidgetClass, frame3,
      XmNverticalSpacing, SPACE_B,
      XmNhorizontalSpacing, SPACE_B,
      NULL);

   modesLabel = XtVaCreateManagedWidget ("Modes", xmLabelWidgetClass, modeForm,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   QPSKwid = XtVaCreateManagedWidget ("QPSK", xmToggleButtonWidgetClass,
      modeForm,
      XmNtopAttachment, XmATTACH_NONE,
      //XmNtopAttachment, XmATTACH_WIDGET,
      //XmNtopWidget, DCDwid,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNshadowThickness, 2,
      NULL);

   DCDwid = XtVaCreateManagedWidget ("DCD", xmToggleButtonWidgetClass,
      modeForm,
      XmNtopAttachment, XmATTACH_NONE,
      XmNtopWidget, modesLabel,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, QPSKwid,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNshadowThickness, 2,
      NULL);


   /*
    * Create the popup menu to clear second rx text widgets
    */
   xs[0] = XmStringCreateLocalized ("Rx Text");
   xs[1] = XmStringCreateLocalized ("Clear");

   clrRxPopup = XmVaCreateSimplePopupMenu(rxText, "clrRx", clrTextCB,
      XmVaTITLE, xs[0],
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, xs[1], ' ', NULL, NULL,
      NULL);

/*
 * patch for mouse grab bug in xorg
  */
#if 1
   #if XmVersion >=2000
      fprintf (stderr, "newer XmVersion %d\n", XmVersion);
      XtVaSetValues (clrRxPopup,
      XmNpopupEnabled, XmPOPUP_DISABLED,
         NULL);
      XtUngrabButton (rxText, AnyButton, AnyModifier);
   #else
      fprintf (stderr, "older XmVersion %d\n", XmVersion);
      XtVaSetValues (clrRxText,
         XmNpopupEnabled, False,
         NULL);
   #endif
#endif


   XtVaSetValues (clrRxPopup,      /* userdata is text window to clear */
      XmNuserData, rxText,
      NULL);

   XmStringFree (xs[0]);
   XmStringFree (xs[1]);


   /* Add Callbacks */
   /*
    * AFC and QPSK TB Callbacks
    */
   XtAddCallback(AFCwid, XmNvalueChangedCallback, decAfcCB, (XtPointer)this);
   XtAddCallback(QPSKwid, XmNvalueChangedCallback, decQpskCB, (XtPointer)this);

   /*
    * Up/Down Arrows for Rx Freq
    */
   XtAddCallback(rxDownArrow, XmNactivateCallback, decArrowCB, (XtPointer)this);
   XtAddCallback(rxUpArrow, XmNactivateCallback, decArrowCB, (XtPointer)this);

   /*
    * Swap and Close Callbacks
    */
   XtAddCallback(swapBtn, XmNactivateCallback,swapCB,(XtPointer)this);
   XtAddCallback(closeBtn, XmNactivateCallback, closeProc, (XtPointer)this);

   /*
    * rxFreq Callbacks
    */
   XtAddCallback(rx2FreqText, XmNfocusCallback, rxFreqFocusCB,
                 (XtPointer)this);
   XtAddCallback(rx2FreqText, XmNlosingFocusCallback, rxFreqFocusCB,
		 (XtPointer)this);
   XtAddCallback(rx2FreqText, XmNmodifyVerifyCallback, freqTextCB,
                 (XtPointer)this);
   XtAddCallback(rx2FreqText, XmNactivateCallback, freqTextCB, 
		 (XtPointer)this);

   /*
    *  Rx ScrollBar Callbacks
    */
   XtAddCallback (rxScrollBar, XmNdragCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNincrementCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNdecrementCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNpageIncrementCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNpageDecrementCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNtoTopCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNtoBottomCallback, rxScrollBarCB,
                 (XtPointer) this);
   XtAddCallback (rxScrollBar, XmNvalueChangedCallback, rxScrollBarCB,
                 (XtPointer) this);

   /*
    * Scope Expose Callback
    */
   XtAddCallback(scopeDA, XmNexposeCallback, decScopeCB, (XtPointer)this);

   /*
    * Event handler for clearing rx windows
    */
   XtAddEventHandler (rxText, ButtonPressMask, False, popupHandler,
                     (XtPointer) clrRxPopup);


   XtManageChild (pbForm);
   XtManageChild (modeForm);
   XtManageChild (rxFreqCombo);
   XtManageChild (centerForm);
   XtManageChild (frame1);
   XtManageChild (frame2a);
   XtManageChild (frame2);
   XtManageChild (frame3);
   XtManageChild (bottomForm);
   XtManageChild (rxTextSW);
   XtManageChild (mainForm);

   /* Get desired X-Y location for the channel and then */
   XtVaSetValues (dialogShell,
      XmNx, winlocs[ch][0] - twpskCB.getBorderX(),
      XmNy, winlocs[ch][1] - twpskCB.getBorderY(),
      NULL);

   /* get height and width and make it the minimums */
   XtVaGetValues (dialogShell,
      XmNheight, &height,
      XmNwidth, &width,
      NULL);

   XtVaSetValues (dialogShell,
      XmNminHeight, height,
      XmNminWidth, width,
      NULL);

   dscope.scope_width = SCOPE_HEIGHT;
   dscope.border_width = 2;

   dscope.setup(shell, scopeDA);
   dscope.drawcirc();
   dscope.drawline(90, 4, 1);
}
