var doIntegrate = function (integrate) {
  chrome.tabs.query({currentWindow: true, active: true}, function (tabs) {
    chrome.runtime.sendMessage({tabId: tabs[0].id, method: "on_user_infobar_request_result", integrate: integrate}
                               , function (response) {});
    window.close();
  });
};

window.onload = function () {
  chrome.runtime.getBackgroundPage(function (bg) {
    document.getElementById('notintegrate').onclick = function () { doIntegrate(false); };
    document.getElementById('integrate').onclick = function () { doIntegrate(true); };

    chrome.tabs.query({currentWindow: true, active: true}, function (tabs) {
      if (tabs.length === 0) {
        window.close();
        return;
      }
      if (!bg || !bg.background_page) {
        window.close();
        return;
      }
      var msg = bg.background_page.getMessageForTabId(tabs[0].id);
      if (msg == null) {
        window.close();
        return;
      }
      document.getElementById ('content').style.display = "block";
      document.getElementById ('message').innerHTML = msg || "";
    });
  });
};

