// ==UserScript==
// @include       http://www.pandora.com/*
// @include       https://www.pandora.com/*
// @require       utils.js
// ==/UserScript==

// This placeholder gets munged with real data at build time.
var WebappsGettextDict = JSON.parse(unescape(
    "%7B%22GETTEXT%22%3A%22PLACEHOLDER%22%7D"
));

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['topnav', 'brandingBar'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function getTrackInfo() {
    var title = null;
    var artLocation = null;
    var album = null;
    var artist = null;
    try {
        artLocation = document.evaluate('//div[@id="playerBar"]/div[@class="highlight"]/div[@class="columns"]/div[@class="rightcolumn"]/div[@class="nowplaying"]/div[@class="cd_menu"]/div[@class="cd_icon"]/div[@class="albumArt"]/img',
                                        document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.src;
        title = document.evaluate('//div[@id="playerBar"]/div[@class="highlight"]/div[@class="columns"]/div[@class="rightcolumn"]/div[@class="nowplaying"]/div[@class="info"]/div[1]/a',
                                  document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.textContent;
        album = document.evaluate('//div[@id="playerBar"]/div[@class="highlight"]/div[@class="columns"]/div[@class="rightcolumn"]/div[@class="nowplaying"]/div[@class="info"]/div[3]/a',
                                  document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.textContent;
        artist = document.evaluate('//div[@id="playerBar"]/div[@class="highlight"]/div[@class="columns"]/div[@class="rightcolumn"]/div[@class="nowplaying"]/div[@class="info"]/div[2]/a',
                                   document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue.textContent;
    } catch (x) {}

    if (!artist) {
        return null;
    }

    return {
        title: title,
        album: album,
        artist: artist,
        artLocation: artLocation
    };
}

function changeState(dryRun) {
    var playButton = document.evaluate('//div[@id="playbackControl"]/div[@class="buttons"]/div[@class="playButton"]',
                                       document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;
    var pauseButton = document.evaluate('//div[@id="playbackControl"]/div[@class="buttons"]/div[@class="pauseButton"]',
                                        document, null, XPathResult.FIRST_ORDERED_NODE_TYPE, null).singleNodeValue;

    var paused = playButton.style.display !== 'none';

    if (!dryRun) {
        if (paused) {
            launchClickEvent(playButton);
        } else {
            launchClickEvent(pauseButton);
        }
    }

    if (!paused) {
        Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PLAYING);
    } else {
        Unity.MediaPlayer.setPlaybackState(Unity.MediaPlayer.PlaybackState.PAUSED);
    }
}


function musicPlayerSetup() {
    Unity.MediaPlayer.init("pandora.com");
    Unity.MediaPlayer.setCanGoPrevious(false);

    setInterval(wrapCallback(function retry() {
        var trackInfo = getTrackInfo(), i;

        if (trackInfo) {
            Unity.MediaPlayer.setTrack(trackInfo);
        }
        changeState(true);

        var stations = document.getElementsByClassName('stationNameText');
        for (i = 0; i < stations.length; i++) {
            console.log(stations[i].textContent);
            //stations[i].click()
        }
    }), 1000);

    Unity.MediaPlayer.onPlayPause(wrapCallback(function () {
        changeState(false);
    }));

    Unity.MediaPlayer.onNext(wrapCallback(function () {
        var node = document.evaluate('//div[@id="playbackControl"]/div[@class="buttons"]/div[@class="skipButton"]',
                                     document,
                                     null,
                                     XPathResult.FIRST_ORDERED_NODE_TYPE,
                                     null)
                           .singleNodeValue;
        launchClickEvent(node);
    }));
}

if (isCorrectPage()) {
    Unity.init({ name: "pandora.com",
                 domain: 'pandora.com',
                 homepage: 'http://www.pandora.com/',
                 iconUrl: 'http://pandora.com/img/pandora-logo.png',
                 crop: true,
                 onInit: wrapCallback(musicPlayerSetup) });
}
