/* valageniescanner.c generated by valac, the Vala compiler
 * generated from valageniescanner.vala, do not modify */

/* valageniescanner.vala
 *
 * Copyright (C) 2008-2012  Jamie McCracken, Jürg Billeter
 * Based on code by Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jamie McCracken jamiemcc gnome org
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_GENIE_SCANNER_TYPE_CONDITIONAL (vala_genie_scanner_conditional_get_type ())
typedef struct _ValaGenieScannerConditional ValaGenieScannerConditional;

#define VALA_GENIE_SCANNER_TYPE_STATE (vala_genie_scanner_state_get_type ())
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ValaGenieParamSpecScanner ValaGenieParamSpecScanner;

struct _ValaGenieScannerConditional {
	gboolean matched;
	gboolean else_found;
	gboolean skip_section;
};

typedef enum  {
	VALA_GENIE_SCANNER_STATE_PARENS,
	VALA_GENIE_SCANNER_STATE_BRACE,
	VALA_GENIE_SCANNER_STATE_BRACKET,
	VALA_GENIE_SCANNER_STATE_REGEX_LITERAL,
	VALA_GENIE_SCANNER_STATE_TEMPLATE,
	VALA_GENIE_SCANNER_STATE_TEMPLATE_PART
} ValaGenieScannerState;

struct _ValaGenieScannerPrivate {
	ValaSourceFile* _source_file;
	gint _indent_spaces;
	gchar* begin;
	gchar* current;
	gchar* end;
	gint line;
	gint column;
	gint current_indent_level;
	gint indent_level;
	gint pending_dedents;
	gint open_parens_count;
	gint open_brace_count;
	ValaGenieTokenType last_token;
	gboolean parse_started;
	ValaComment* _comment;
	ValaGenieScannerConditional* conditional_stack;
	gint conditional_stack_length1;
	gint _conditional_stack_size_;
	ValaGenieScannerState* state_stack;
	gint state_stack_length1;
	gint _state_stack_size_;
};

struct _ValaGenieParamSpecScanner {
	GParamSpec parent_instance;
};


static gpointer vala_genie_scanner_parent_class = NULL;

static GType vala_genie_scanner_conditional_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGenieScannerConditional* vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self);
static void vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self);
static GType vala_genie_scanner_state_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_GENIE_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GENIE_TYPE_SCANNER, ValaGenieScannerPrivate))
static void vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                         ValaSourceFile* value);
static gboolean vala_genie_scanner_in_template (ValaGenieScanner* self);
static gboolean vala_genie_scanner_in_template_part (ValaGenieScanner* self);
static gboolean vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                           gchar c);
static gboolean vala_genie_scanner_in_regex_literal (ValaGenieScanner* self);
static ValaSourceReference* vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                                              gint offset,
                                                              gint length);
static gboolean vala_genie_scanner_matches (gchar* begin,
                                     const gchar* keyword);
static void _vala_array_add2 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add3 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add4 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add5 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void vala_genie_scanner_space (ValaGenieScanner* self);
static void vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self);
static inline gboolean vala_genie_scanner_newline (ValaGenieScanner* self);
static gboolean vala_genie_scanner_skip_newlines (ValaGenieScanner* self);
static gint vala_genie_scanner_count_tabs (ValaGenieScanner* self);
static void _vala_array_add6 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add7 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add8 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add9 (ValaGenieScannerState* * array,
                       int* length,
                       int* size,
                       ValaGenieScannerState value);
static void _vala_array_add10 (ValaGenieScannerState* * array,
                        int* length,
                        int* size,
                        ValaGenieScannerState value);
static gboolean vala_genie_scanner_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_directive (ValaGenieScanner* self);
static gboolean vala_genie_scanner_comment (ValaGenieScanner* self,
                                     gboolean file_comment);
static void vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                      const gchar* comment_item,
                                      ValaSourceReference* source_reference,
                                      gboolean file_comment);
static gboolean vala_genie_scanner_skip_tabs (ValaGenieScanner* self);
static gboolean vala_genie_scanner_pp_whitespace (ValaGenieScanner* self);
static void vala_genie_scanner_pp_space (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_if (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_else (ValaGenieScanner* self);
static void vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self);
static void vala_genie_scanner_pp_eol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self);
static void _vala_array_add11 (ValaGenieScannerConditional* * array,
                        int* length,
                        int* size,
                        const ValaGenieScannerConditional* value);
static gboolean vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self);
static gboolean vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self);
static void vala_genie_scanner_finalize (ValaGenieScanner * obj);


static GType
vala_genie_scanner_state_get_type (void)
{
	static volatile gsize vala_genie_scanner_state_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_state_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GENIE_SCANNER_STATE_PARENS, "VALA_GENIE_SCANNER_STATE_PARENS", "parens"}, {VALA_GENIE_SCANNER_STATE_BRACE, "VALA_GENIE_SCANNER_STATE_BRACE", "brace"}, {VALA_GENIE_SCANNER_STATE_BRACKET, "VALA_GENIE_SCANNER_STATE_BRACKET", "bracket"}, {VALA_GENIE_SCANNER_STATE_REGEX_LITERAL, "VALA_GENIE_SCANNER_STATE_REGEX_LITERAL", "regex-literal"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE, "VALA_GENIE_SCANNER_STATE_TEMPLATE", "template"}, {VALA_GENIE_SCANNER_STATE_TEMPLATE_PART, "VALA_GENIE_SCANNER_STATE_TEMPLATE_PART", "template-part"}, {0, NULL, NULL}};
		GType vala_genie_scanner_state_type_id;
		vala_genie_scanner_state_type_id = g_enum_register_static ("ValaGenieScannerState", values);
		g_once_init_leave (&vala_genie_scanner_state_type_id__volatile, vala_genie_scanner_state_type_id);
	}
	return vala_genie_scanner_state_type_id__volatile;
}


ValaGenieScanner*
vala_genie_scanner_construct (GType object_type,
                              ValaSourceFile* source_file)
{
	ValaGenieScanner* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (source_file != NULL, NULL);
	self = (ValaGenieScanner*) g_type_create_instance (object_type);
	vala_genie_scanner_set_source_file (self, source_file);
	_tmp0_ = vala_source_file_get_mapped_contents (source_file);
	self->priv->begin = _tmp0_;
	_tmp1_ = self->priv->begin;
	self->priv->end = _tmp1_ + vala_source_file_get_mapped_length (source_file);
	_tmp2_ = self->priv->begin;
	self->priv->current = _tmp2_;
	self->priv->_indent_spaces = 0;
	self->priv->line = 1;
	self->priv->column = 1;
	self->priv->current_indent_level = 0;
	self->priv->indent_level = 0;
	self->priv->pending_dedents = 0;
	self->priv->open_parens_count = 0;
	self->priv->open_brace_count = 0;
	self->priv->parse_started = FALSE;
	self->priv->last_token = VALA_GENIE_TOKEN_TYPE_NONE;
	return self;
}


ValaGenieScanner*
vala_genie_scanner_new (ValaSourceFile* source_file)
{
	return vala_genie_scanner_construct (VALA_GENIE_TYPE_SCANNER, source_file);
}


static gboolean
vala_genie_scanner_in_template (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_genie_scanner_in_template_part (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_TEMPLATE_PART;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_genie_scanner_is_ident_char (ValaGenieScanner* self,
                                  gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_genie_scanner_in_regex_literal (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerState* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->state_stack;
	_tmp1__length1 = self->priv->state_stack_length1;
	if (_tmp1__length1 > 0) {
		ValaGenieScannerState* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerState* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerState _tmp4_;
		_tmp2_ = self->priv->state_stack;
		_tmp2__length1 = self->priv->state_stack_length1;
		_tmp3_ = self->priv->state_stack;
		_tmp3__length1 = self->priv->state_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp0_ = _tmp4_ == VALA_GENIE_SCANNER_STATE_REGEX_LITERAL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static ValaSourceReference*
vala_genie_scanner_get_source_reference (ValaGenieScanner* self,
                                         gint offset,
                                         gint length)
{
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_ = {0};
	gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	ValaSourceLocation _tmp8_ = {0};
	ValaSourceReference* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_tmp4_, _tmp1_, _tmp2_, _tmp3_ + offset);
	_tmp5_ = self->priv->current;
	_tmp6_ = self->priv->line;
	_tmp7_ = self->priv->column;
	vala_source_location_init (&_tmp8_, _tmp5_ + length, _tmp6_, (_tmp7_ + offset) + length);
	_tmp9_ = vala_source_reference_new (_tmp0_, &_tmp4_, &_tmp8_);
	result = _tmp9_;
	return result;
}


ValaGenieTokenType
vala_genie_scanner_read_regex_token (ValaGenieScanner* self,
                                     ValaSourceLocation* token_begin,
                                     ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType result = 0;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp93_;
	gchar* _tmp99_;
	gint _tmp100_;
	gint _tmp101_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '/':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean fl_i = FALSE;
				gboolean fl_s = FALSE;
				gboolean fl_m = FALSE;
				gboolean fl_x = FALSE;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_REGEX_LITERAL;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				fl_i = FALSE;
				fl_s = FALSE;
				fl_m = FALSE;
				fl_x = FALSE;
				while (TRUE) {
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					gchar* _tmp13_;
					gchar _tmp14_;
					gchar* _tmp21_;
					gchar _tmp22_;
					gchar* _tmp39_;
					gint _tmp40_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					if (_tmp14_ == 'i') {
						_tmp12_ = TRUE;
					} else {
						gchar* _tmp15_;
						gchar _tmp16_;
						_tmp15_ = self->priv->current;
						_tmp16_ = _tmp15_[0];
						_tmp12_ = _tmp16_ == 's';
					}
					if (_tmp12_) {
						_tmp11_ = TRUE;
					} else {
						gchar* _tmp17_;
						gchar _tmp18_;
						_tmp17_ = self->priv->current;
						_tmp18_ = _tmp17_[0];
						_tmp11_ = _tmp18_ == 'm';
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						gchar* _tmp19_;
						gchar _tmp20_;
						_tmp19_ = self->priv->current;
						_tmp20_ = _tmp19_[0];
						_tmp10_ = _tmp20_ == 'x';
					}
					if (!_tmp10_) {
						break;
					}
					_tmp21_ = self->priv->current;
					_tmp22_ = _tmp21_[0];
					switch (_tmp22_) {
						case 'i':
						{
							gboolean _tmp23_;
							_tmp23_ = fl_i;
							if (_tmp23_) {
								gint _tmp24_;
								ValaSourceReference* _tmp25_;
								ValaSourceReference* _tmp26_;
								_tmp24_ = token_length_in_chars;
								_tmp25_ = vala_genie_scanner_get_source_reference (self, _tmp24_, 0);
								_tmp26_ = _tmp25_;
								vala_report_error (_tmp26_, "modifier 'i' used more than once");
								_vala_source_reference_unref0 (_tmp26_);
							}
							fl_i = TRUE;
							break;
						}
						case 's':
						{
							gboolean _tmp27_;
							_tmp27_ = fl_s;
							if (_tmp27_) {
								gint _tmp28_;
								ValaSourceReference* _tmp29_;
								ValaSourceReference* _tmp30_;
								_tmp28_ = token_length_in_chars;
								_tmp29_ = vala_genie_scanner_get_source_reference (self, _tmp28_, 0);
								_tmp30_ = _tmp29_;
								vala_report_error (_tmp30_, "modifier 's' used more than once");
								_vala_source_reference_unref0 (_tmp30_);
							}
							fl_s = TRUE;
							break;
						}
						case 'm':
						{
							gboolean _tmp31_;
							_tmp31_ = fl_m;
							if (_tmp31_) {
								gint _tmp32_;
								ValaSourceReference* _tmp33_;
								ValaSourceReference* _tmp34_;
								_tmp32_ = token_length_in_chars;
								_tmp33_ = vala_genie_scanner_get_source_reference (self, _tmp32_, 0);
								_tmp34_ = _tmp33_;
								vala_report_error (_tmp34_, "modifier 'm' used more than once");
								_vala_source_reference_unref0 (_tmp34_);
							}
							fl_m = TRUE;
							break;
						}
						case 'x':
						{
							gboolean _tmp35_;
							_tmp35_ = fl_x;
							if (_tmp35_) {
								gint _tmp36_;
								ValaSourceReference* _tmp37_;
								ValaSourceReference* _tmp38_;
								_tmp36_ = token_length_in_chars;
								_tmp37_ = vala_genie_scanner_get_source_reference (self, _tmp36_, 0);
								_tmp38_ = _tmp37_;
								vala_report_error (_tmp38_, "modifier 'x' used more than once");
								_vala_source_reference_unref0 (_tmp38_);
							}
							fl_x = TRUE;
							break;
						}
						default:
						break;
					}
					_tmp39_ = self->priv->current;
					self->priv->current = _tmp39_ + 1;
					_tmp40_ = token_length_in_chars;
					token_length_in_chars = _tmp40_ + 1;
				}
				break;
			}
			default:
			{
				gboolean _tmp81_ = FALSE;
				gchar* _tmp82_;
				gchar* _tmp83_;
				type = VALA_GENIE_TOKEN_TYPE_REGEX_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp41_ = FALSE;
					gchar* _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp46_;
					gchar _tmp47_;
					_tmp42_ = self->priv->current;
					_tmp43_ = self->priv->end;
					if (_tmp42_ < _tmp43_) {
						gchar* _tmp44_;
						gchar _tmp45_;
						_tmp44_ = self->priv->current;
						_tmp45_ = _tmp44_[0];
						_tmp41_ = _tmp45_ != '/';
					} else {
						_tmp41_ = FALSE;
					}
					if (!_tmp41_) {
						break;
					}
					_tmp46_ = self->priv->current;
					_tmp47_ = _tmp46_[0];
					if (_tmp47_ == '\\') {
						gchar* _tmp48_;
						gint _tmp49_;
						gchar* _tmp50_;
						gchar* _tmp51_;
						gchar* _tmp52_;
						gchar _tmp53_;
						_tmp48_ = self->priv->current;
						self->priv->current = _tmp48_ + 1;
						_tmp49_ = token_length_in_chars;
						token_length_in_chars = _tmp49_ + 1;
						_tmp50_ = self->priv->current;
						_tmp51_ = self->priv->end;
						if (_tmp50_ >= _tmp51_) {
							break;
						}
						_tmp52_ = self->priv->current;
						_tmp53_ = _tmp52_[0];
						switch (_tmp53_) {
							case '\'':
							case '"':
							case '\\':
							case '/':
							case '^':
							case '$':
							case '.':
							case '[':
							case ']':
							case '{':
							case '}':
							case '(':
							case ')':
							case '?':
							case '*':
							case '+':
							case '-':
							case '#':
							case '&':
							case '~':
							case ':':
							case ';':
							case '<':
							case '>':
							case '|':
							case '%':
							case '=':
							case '@':
							case '0':
							case 'b':
							case 'B':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							case 'a':
							case 'A':
							case 'p':
							case 'P':
							case 'e':
							case 'd':
							case 'D':
							case 's':
							case 'S':
							case 'w':
							case 'W':
							case 'G':
							case 'z':
							case 'Z':
							{
								gchar* _tmp54_;
								gint _tmp55_;
								_tmp54_ = self->priv->current;
								self->priv->current = _tmp54_ + 1;
								_tmp55_ = token_length_in_chars;
								token_length_in_chars = _tmp55_ + 1;
								break;
							}
							case 'x':
							{
								gchar* _tmp56_;
								gint _tmp57_;
								_tmp56_ = self->priv->current;
								self->priv->current = _tmp56_ + 1;
								_tmp57_ = token_length_in_chars;
								token_length_in_chars = _tmp57_ + 1;
								while (TRUE) {
									gboolean _tmp58_ = FALSE;
									gchar* _tmp59_;
									gchar* _tmp60_;
									gchar* _tmp63_;
									gint _tmp64_;
									_tmp59_ = self->priv->current;
									_tmp60_ = self->priv->end;
									if (_tmp59_ < _tmp60_) {
										gchar* _tmp61_;
										gchar _tmp62_;
										_tmp61_ = self->priv->current;
										_tmp62_ = _tmp61_[0];
										_tmp58_ = g_ascii_isxdigit (_tmp62_);
									} else {
										_tmp58_ = FALSE;
									}
									if (!_tmp58_) {
										break;
									}
									_tmp63_ = self->priv->current;
									self->priv->current = _tmp63_ + 1;
									_tmp64_ = token_length_in_chars;
									token_length_in_chars = _tmp64_ + 1;
								}
								break;
							}
							default:
							{
								gint _tmp65_;
								ValaSourceReference* _tmp66_;
								ValaSourceReference* _tmp67_;
								_tmp65_ = token_length_in_chars;
								_tmp66_ = vala_genie_scanner_get_source_reference (self, _tmp65_, 0);
								_tmp67_ = _tmp66_;
								vala_report_error (_tmp67_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp67_);
								break;
							}
						}
					} else {
						gchar* _tmp68_;
						gchar _tmp69_;
						_tmp68_ = self->priv->current;
						_tmp69_ = _tmp68_[0];
						if (_tmp69_ == '\n') {
							break;
						} else {
							gunichar u = 0U;
							gchar* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
							gunichar _tmp73_;
							_tmp70_ = self->priv->current;
							_tmp71_ = self->priv->end;
							_tmp72_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp70_, (gssize) ((glong) (_tmp71_ - _tmp72_)));
							_tmp73_ = u;
							if (_tmp73_ != ((gunichar) -1)) {
								gchar* _tmp74_;
								gunichar _tmp75_;
								gint _tmp76_;
								_tmp74_ = self->priv->current;
								_tmp75_ = u;
								self->priv->current = _tmp74_ + g_unichar_to_utf8 (_tmp75_, NULL);
								_tmp76_ = token_length_in_chars;
								token_length_in_chars = _tmp76_ + 1;
							} else {
								gchar* _tmp77_;
								gint _tmp78_;
								ValaSourceReference* _tmp79_;
								ValaSourceReference* _tmp80_;
								_tmp77_ = self->priv->current;
								self->priv->current = _tmp77_ + 1;
								_tmp78_ = token_length_in_chars;
								_tmp79_ = vala_genie_scanner_get_source_reference (self, _tmp78_, 0);
								_tmp80_ = _tmp79_;
								vala_report_error (_tmp80_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp80_);
							}
						}
					}
				}
				_tmp82_ = self->priv->current;
				_tmp83_ = self->priv->end;
				if (_tmp82_ >= _tmp83_) {
					_tmp81_ = TRUE;
				} else {
					gchar* _tmp84_;
					gchar _tmp85_;
					_tmp84_ = self->priv->current;
					_tmp85_ = _tmp84_[0];
					_tmp81_ = _tmp85_ == '\n';
				}
				if (_tmp81_) {
					gint _tmp86_;
					ValaSourceReference* _tmp87_;
					ValaSourceReference* _tmp88_;
					gint _tmp89_;
					ValaSourceLocation _tmp90_ = {0};
					ValaSourceLocation _tmp91_ = {0};
					ValaGenieTokenType _tmp92_;
					_tmp86_ = token_length_in_chars;
					_tmp87_ = vala_genie_scanner_get_source_reference (self, _tmp86_, 0);
					_tmp88_ = _tmp87_;
					vala_report_error (_tmp88_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp88_);
					_tmp89_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp89_ - 1;
					_tmp92_ = vala_genie_scanner_read_token (self, &_tmp90_, &_tmp91_);
					_vala_token_begin = _tmp90_;
					_vala_token_end = _tmp91_;
					result = _tmp92_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				break;
			}
		}
	}
	_tmp93_ = token_length_in_chars;
	if (_tmp93_ < 0) {
		gint _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		_tmp94_ = self->priv->column;
		_tmp95_ = self->priv->current;
		_tmp96_ = begin;
		self->priv->column = _tmp94_ + ((gint) (_tmp95_ - _tmp96_));
	} else {
		gint _tmp97_;
		gint _tmp98_;
		_tmp97_ = self->priv->column;
		_tmp98_ = token_length_in_chars;
		self->priv->column = _tmp97_ + _tmp98_;
	}
	_tmp99_ = self->priv->current;
	_tmp100_ = self->priv->line;
	_tmp101_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp99_, _tmp100_, _tmp101_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


void
vala_genie_scanner_seek (ValaGenieScanner* self,
                         ValaSourceLocation* location)
{
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	ValaSourceLocation _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (location != NULL);
	_tmp0_ = *location;
	_tmp1_ = _tmp0_.pos;
	self->priv->current = _tmp1_;
	_tmp2_ = *location;
	_tmp3_ = _tmp2_.line;
	self->priv->line = _tmp3_;
	_tmp4_ = *location;
	_tmp5_ = _tmp4_.column;
	self->priv->column = _tmp5_;
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->conditional_stack = NULL;
	self->priv->conditional_stack_length1 = 0;
	self->priv->_conditional_stack_size_ = self->priv->conditional_stack_length1;
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
	self->priv->state_stack = NULL;
	self->priv->state_stack_length1 = 0;
	self->priv->_state_stack_size_ = self->priv->state_stack_length1;
}


ValaGenieTokenType
vala_genie_scanner_get_identifier_or_keyword (gchar* begin,
                                              gint len)
{
	ValaGenieTokenType result = 0;
	switch (len) {
		case 2:
		{
			gchar _tmp0_;
			_tmp0_ = begin[0];
			switch (_tmp0_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "as")) {
						result = VALA_GENIE_TOKEN_TYPE_AS;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "do")) {
						result = VALA_GENIE_TOKEN_TYPE_DO;
						return result;
					}
					break;
				}
				case 'i':
				{
					gchar _tmp1_;
					_tmp1_ = begin[1];
					switch (_tmp1_) {
						case 'f':
						{
							result = VALA_GENIE_TOKEN_TYPE_IF;
							return result;
						}
						case 'n':
						{
							result = VALA_GENIE_TOKEN_TYPE_IN;
							return result;
						}
						case 's':
						{
							result = VALA_GENIE_TOKEN_TYPE_IS;
							return result;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "of")) {
						result = VALA_GENIE_TOKEN_TYPE_OF;
						return result;
					}
					if (vala_genie_scanner_matches (begin, "or")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_OR;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "to")) {
						result = VALA_GENIE_TOKEN_TYPE_TO;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 3:
		{
			gchar _tmp2_;
			_tmp2_ = begin[0];
			switch (_tmp2_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "and")) {
						result = VALA_GENIE_TOKEN_TYPE_OP_AND;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "def")) {
						result = VALA_GENIE_TOKEN_TYPE_DEF;
						return result;
					}
					break;
				}
				case 'f':
				{
					if (vala_genie_scanner_matches (begin, "for")) {
						result = VALA_GENIE_TOKEN_TYPE_FOR;
						return result;
					}
					break;
				}
				case 'g':
				{
					if (vala_genie_scanner_matches (begin, "get")) {
						result = VALA_GENIE_TOKEN_TYPE_GET;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "isa")) {
						result = VALA_GENIE_TOKEN_TYPE_ISA;
						return result;
					}
					break;
				}
				case 'n':
				{
					gchar _tmp3_;
					_tmp3_ = begin[1];
					switch (_tmp3_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "new")) {
								result = VALA_GENIE_TOKEN_TYPE_NEW;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "not")) {
								result = VALA_GENIE_TOKEN_TYPE_OP_NEG;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "out")) {
						result = VALA_GENIE_TOKEN_TYPE_OUT;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "ref")) {
						result = VALA_GENIE_TOKEN_TYPE_REF;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "set")) {
						result = VALA_GENIE_TOKEN_TYPE_SET;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "try")) {
						result = VALA_GENIE_TOKEN_TYPE_TRY;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "var")) {
						result = VALA_GENIE_TOKEN_TYPE_VAR;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 4:
		{
			gchar _tmp4_;
			_tmp4_ = begin[0];
			switch (_tmp4_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "case")) {
						result = VALA_GENIE_TOKEN_TYPE_CASE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "dict")) {
						result = VALA_GENIE_TOKEN_TYPE_DICT;
						return result;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp5_;
					_tmp5_ = begin[1];
					switch (_tmp5_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "else")) {
								result = VALA_GENIE_TOKEN_TYPE_ELSE;
								return result;
							}
							break;
						}
						case 'n':
						{
							if (vala_genie_scanner_matches (begin, "enum")) {
								result = VALA_GENIE_TOKEN_TYPE_ENUM;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "init")) {
						result = VALA_GENIE_TOKEN_TYPE_INIT;
						return result;
					}
					break;
				}
				case 'l':
				{
					gchar _tmp6_;
					_tmp6_ = begin[1];
					switch (_tmp6_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "list")) {
								result = VALA_GENIE_TOKEN_TYPE_LIST;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "lock")) {
								result = VALA_GENIE_TOKEN_TYPE_LOCK;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "null")) {
						result = VALA_GENIE_TOKEN_TYPE_NULL;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp7_;
					_tmp7_ = begin[1];
					switch (_tmp7_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "pass")) {
								result = VALA_GENIE_TOKEN_TYPE_PASS;
								return result;
							}
							break;
						}
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "prop")) {
								result = VALA_GENIE_TOKEN_TYPE_PROP;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "self")) {
						result = VALA_GENIE_TOKEN_TYPE_THIS;
						return result;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "true")) {
						result = VALA_GENIE_TOKEN_TYPE_TRUE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "uses")) {
						result = VALA_GENIE_TOKEN_TYPE_USES;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "void")) {
						result = VALA_GENIE_TOKEN_TYPE_VOID;
						return result;
					}
					break;
				}
				case 'w':
				{
					gchar _tmp8_;
					_tmp8_ = begin[1];
					switch (_tmp8_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "weak")) {
								result = VALA_GENIE_TOKEN_TYPE_WEAK;
								return result;
							}
							break;
						}
						case 'h':
						{
							if (vala_genie_scanner_matches (begin, "when")) {
								result = VALA_GENIE_TOKEN_TYPE_WHEN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 5:
		{
			gchar _tmp9_;
			_tmp9_ = begin[0];
			switch (_tmp9_) {
				case 'a':
				{
					gchar _tmp10_;
					_tmp10_ = begin[1];
					switch (_tmp10_) {
						case 'r':
						{
							if (vala_genie_scanner_matches (begin, "array")) {
								result = VALA_GENIE_TOKEN_TYPE_ARRAY;
								return result;
							}
							break;
						}
						case 's':
						{
							if (vala_genie_scanner_matches (begin, "async")) {
								result = VALA_GENIE_TOKEN_TYPE_ASYNC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'b':
				{
					if (vala_genie_scanner_matches (begin, "break")) {
						result = VALA_GENIE_TOKEN_TYPE_BREAK;
						return result;
					}
					break;
				}
				case 'c':
				{
					gchar _tmp11_;
					_tmp11_ = begin[1];
					switch (_tmp11_) {
						case 'l':
						{
							if (vala_genie_scanner_matches (begin, "class")) {
								result = VALA_GENIE_TOKEN_TYPE_CLASS;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "const")) {
								result = VALA_GENIE_TOKEN_TYPE_CONST;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "event")) {
						result = VALA_GENIE_TOKEN_TYPE_EVENT;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp12_;
					_tmp12_ = begin[1];
					switch (_tmp12_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "false")) {
								result = VALA_GENIE_TOKEN_TYPE_FALSE;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "final")) {
								result = VALA_GENIE_TOKEN_TYPE_FINAL;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "owned")) {
						result = VALA_GENIE_TOKEN_TYPE_OWNED;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "print")) {
						result = VALA_GENIE_TOKEN_TYPE_PRINT;
						return result;
					}
					break;
				}
				case 's':
				{
					if (vala_genie_scanner_matches (begin, "super")) {
						result = VALA_GENIE_TOKEN_TYPE_SUPER;
						return result;
					}
					break;
				}
				case 'r':
				{
					if (vala_genie_scanner_matches (begin, "raise")) {
						result = VALA_GENIE_TOKEN_TYPE_RAISE;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (begin, "while")) {
						result = VALA_GENIE_TOKEN_TYPE_WHILE;
						return result;
					}
					break;
				}
				case 'y':
				{
					if (vala_genie_scanner_matches (begin, "yield")) {
						result = VALA_GENIE_TOKEN_TYPE_YIELD;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 6:
		{
			gchar _tmp13_;
			_tmp13_ = begin[0];
			switch (_tmp13_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "assert")) {
						result = VALA_GENIE_TOKEN_TYPE_ASSERT;
						return result;
					}
					break;
				}
				case 'd':
				{
					gchar _tmp14_;
					_tmp14_ = begin[1];
					switch (_tmp14_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "delete")) {
								result = VALA_GENIE_TOKEN_TYPE_DELETE;
								return result;
							}
							break;
						}
						case 'o':
						{
							if (vala_genie_scanner_matches (begin, "downto")) {
								result = VALA_GENIE_TOKEN_TYPE_DOWNTO;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					gchar _tmp15_;
					_tmp15_ = begin[1];
					switch (_tmp15_) {
						case 'x':
						{
							gchar _tmp16_;
							_tmp16_ = begin[2];
							switch (_tmp16_) {
								case 'c':
								{
									if (vala_genie_scanner_matches (begin, "except")) {
										result = VALA_GENIE_TOKEN_TYPE_EXCEPT;
										return result;
									}
									break;
								}
								case 't':
								{
									if (vala_genie_scanner_matches (begin, "extern")) {
										result = VALA_GENIE_TOKEN_TYPE_EXTERN;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "inline")) {
						result = VALA_GENIE_TOKEN_TYPE_INLINE;
						return result;
					}
					break;
				}
				case 'p':
				{
					gchar _tmp17_;
					_tmp17_ = begin[1];
					switch (_tmp17_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "params")) {
								result = VALA_GENIE_TOKEN_TYPE_PARAMS;
								return result;
							}
							break;
						}
						case 'u':
						{
							if (vala_genie_scanner_matches (begin, "public")) {
								result = VALA_GENIE_TOKEN_TYPE_PUBLIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp18_;
					_tmp18_ = begin[1];
					switch (_tmp18_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "raises")) {
								result = VALA_GENIE_TOKEN_TYPE_RAISES;
								return result;
							}
							break;
						}
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "return")) {
								result = VALA_GENIE_TOKEN_TYPE_RETURN;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 's':
				{
					gchar _tmp19_;
					_tmp19_ = begin[1];
					switch (_tmp19_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "sealed")) {
								result = VALA_GENIE_TOKEN_TYPE_SEALED;
								return result;
							}
							break;
						}
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "sizeof")) {
								result = VALA_GENIE_TOKEN_TYPE_SIZEOF;
								return result;
							}
							break;
						}
						case 't':
						{
							gchar _tmp20_;
							_tmp20_ = begin[2];
							switch (_tmp20_) {
								case 'a':
								{
									if (vala_genie_scanner_matches (begin, "static")) {
										result = VALA_GENIE_TOKEN_TYPE_STATIC;
										return result;
									}
									break;
								}
								case 'r':
								{
									if (vala_genie_scanner_matches (begin, "struct")) {
										result = VALA_GENIE_TOKEN_TYPE_STRUCT;
										return result;
									}
									break;
								}
								default:
								break;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 't':
				{
					if (vala_genie_scanner_matches (begin, "typeof")) {
						result = VALA_GENIE_TOKEN_TYPE_TYPEOF;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 7:
		{
			gchar _tmp21_;
			_tmp21_ = begin[0];
			switch (_tmp21_) {
				case 'd':
				{
					gchar _tmp22_;
					_tmp22_ = begin[1];
					switch (_tmp22_) {
						case 'e':
						{
							if (vala_genie_scanner_matches (begin, "default")) {
								result = VALA_GENIE_TOKEN_TYPE_DEFAULT;
								return result;
							}
							break;
						}
						case 'y':
						{
							if (vala_genie_scanner_matches (begin, "dynamic")) {
								result = VALA_GENIE_TOKEN_TYPE_DYNAMIC;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "ensures")) {
						result = VALA_GENIE_TOKEN_TYPE_ENSURES;
						return result;
					}
					break;
				}
				case 'f':
				{
					gchar _tmp23_;
					_tmp23_ = begin[1];
					switch (_tmp23_) {
						case 'i':
						{
							if (vala_genie_scanner_matches (begin, "finally")) {
								result = VALA_GENIE_TOKEN_TYPE_FINALLY;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "private")) {
						result = VALA_GENIE_TOKEN_TYPE_PRIVATE;
						return result;
					}
					break;
				}
				case 'u':
				{
					if (vala_genie_scanner_matches (begin, "unowned")) {
						result = VALA_GENIE_TOKEN_TYPE_UNOWNED;
						return result;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "virtual")) {
						result = VALA_GENIE_TOKEN_TYPE_VIRTUAL;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 8:
		{
			gchar _tmp24_;
			_tmp24_ = begin[0];
			switch (_tmp24_) {
				case 'a':
				{
					if (vala_genie_scanner_matches (begin, "abstract")) {
						result = VALA_GENIE_TOKEN_TYPE_ABSTRACT;
						return result;
					}
					break;
				}
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "continue")) {
						result = VALA_GENIE_TOKEN_TYPE_CONTINUE;
						return result;
					}
					break;
				}
				case 'd':
				{
					if (vala_genie_scanner_matches (begin, "delegate")) {
						result = VALA_GENIE_TOKEN_TYPE_DELEGATE;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "internal")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERNAL;
						return result;
					}
					break;
				}
				case 'o':
				{
					if (vala_genie_scanner_matches (begin, "override")) {
						result = VALA_GENIE_TOKEN_TYPE_OVERRIDE;
						return result;
					}
					break;
				}
				case 'r':
				{
					gchar _tmp25_;
					_tmp25_ = begin[2];
					switch (_tmp25_) {
						case 'a':
						{
							if (vala_genie_scanner_matches (begin, "readonly")) {
								result = VALA_GENIE_TOKEN_TYPE_READONLY;
								return result;
							}
							break;
						}
						case 'q':
						{
							if (vala_genie_scanner_matches (begin, "requires")) {
								result = VALA_GENIE_TOKEN_TYPE_REQUIRES;
								return result;
							}
							break;
						}
						default:
						break;
					}
					break;
				}
				case 'v':
				{
					if (vala_genie_scanner_matches (begin, "volatile")) {
						result = VALA_GENIE_TOKEN_TYPE_VOLATILE;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 9:
		{
			gchar _tmp26_;
			_tmp26_ = begin[0];
			switch (_tmp26_) {
				case 'c':
				{
					if (vala_genie_scanner_matches (begin, "construct")) {
						result = VALA_GENIE_TOKEN_TYPE_CONSTRUCT;
						return result;
					}
					break;
				}
				case 'e':
				{
					if (vala_genie_scanner_matches (begin, "exception")) {
						result = VALA_GENIE_TOKEN_TYPE_ERRORDOMAIN;
						return result;
					}
					break;
				}
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "interface")) {
						result = VALA_GENIE_TOKEN_TYPE_INTERFACE;
						return result;
					}
					break;
				}
				case 'n':
				{
					if (vala_genie_scanner_matches (begin, "namespace")) {
						result = VALA_GENIE_TOKEN_TYPE_NAMESPACE;
						return result;
					}
					break;
				}
				case 'p':
				{
					if (vala_genie_scanner_matches (begin, "protected")) {
						result = VALA_GENIE_TOKEN_TYPE_PROTECTED;
						return result;
					}
					break;
				}
				case 'w':
				{
					if (vala_genie_scanner_matches (begin, "writeonly")) {
						result = VALA_GENIE_TOKEN_TYPE_WRITEONLY;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		case 10:
		{
			gchar _tmp27_;
			_tmp27_ = begin[0];
			switch (_tmp27_) {
				case 'i':
				{
					if (vala_genie_scanner_matches (begin, "implements")) {
						result = VALA_GENIE_TOKEN_TYPE_IMPLEMENTS;
						return result;
					}
					break;
				}
				default:
				break;
			}
			break;
		}
		default:
		break;
	}
	result = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
	return result;
}


static void
_vala_array_add2 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add3 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add4 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add5 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaGenieTokenType
vala_genie_scanner_read_template_token (ValaGenieScanner* self,
                                        ValaSourceLocation* token_begin,
                                        ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType result = 0;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint token_length_in_chars = 0;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp97_;
	gchar* _tmp103_;
	gint _tmp104_;
	gint _tmp105_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	begin = _tmp0_;
	_tmp1_ = begin;
	_tmp2_ = self->priv->line;
	_tmp3_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
	token_length_in_chars = -1;
	_tmp4_ = self->priv->current;
	_tmp5_ = self->priv->end;
	if (_tmp4_ >= _tmp5_) {
		type = VALA_GENIE_TOKEN_TYPE_EOF;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		switch (_tmp7_) {
			case '"':
			{
				gchar* _tmp8_;
				gint _tmp9_;
				type = VALA_GENIE_TOKEN_TYPE_CLOSE_TEMPLATE;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->state_stack_length1;
				self->priv->state_stack_length1 = _tmp9_ - 1;
				break;
			}
			case '$':
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gboolean _tmp12_ = FALSE;
				gchar* _tmp13_;
				gchar _tmp14_;
				_tmp10_ = _vala_token_begin.pos;
				_vala_token_begin.pos = _tmp10_ + 1;
				_tmp11_ = self->priv->current;
				self->priv->current = _tmp11_ + 1;
				_tmp13_ = self->priv->current;
				_tmp14_ = _tmp13_[0];
				if (g_ascii_isalpha (_tmp14_)) {
					_tmp12_ = TRUE;
				} else {
					gchar* _tmp15_;
					gchar _tmp16_;
					_tmp15_ = self->priv->current;
					_tmp16_ = _tmp15_[0];
					_tmp12_ = _tmp16_ == '_';
				}
				if (_tmp12_) {
					gint len = 0;
					ValaGenieScannerState* _tmp24_;
					gint _tmp24__length1;
					len = 0;
					while (TRUE) {
						gboolean _tmp17_ = FALSE;
						gchar* _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp22_;
						gint _tmp23_;
						_tmp18_ = self->priv->current;
						_tmp19_ = self->priv->end;
						if (_tmp18_ < _tmp19_) {
							gchar* _tmp20_;
							gchar _tmp21_;
							_tmp20_ = self->priv->current;
							_tmp21_ = _tmp20_[0];
							_tmp17_ = vala_genie_scanner_is_ident_char (self, _tmp21_);
						} else {
							_tmp17_ = FALSE;
						}
						if (!_tmp17_) {
							break;
						}
						_tmp22_ = self->priv->current;
						self->priv->current = _tmp22_ + 1;
						_tmp23_ = len;
						len = _tmp23_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
					_tmp24_ = self->priv->state_stack;
					_tmp24__length1 = self->priv->state_stack_length1;
					_vala_array_add2 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				} else {
					gchar* _tmp25_;
					gchar _tmp26_;
					_tmp25_ = self->priv->current;
					_tmp26_ = _tmp25_[0];
					if (_tmp26_ == '(') {
						gchar* _tmp27_;
						gint _tmp28_;
						ValaGenieScannerState* _tmp29_;
						gint _tmp29__length1;
						ValaSourceLocation _tmp30_ = {0};
						ValaSourceLocation _tmp31_ = {0};
						ValaGenieTokenType _tmp32_;
						_tmp27_ = self->priv->current;
						self->priv->current = _tmp27_ + 1;
						_tmp28_ = self->priv->column;
						self->priv->column = _tmp28_ + 2;
						_tmp29_ = self->priv->state_stack;
						_tmp29__length1 = self->priv->state_stack_length1;
						_vala_array_add3 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
						_tmp32_ = vala_genie_scanner_read_token (self, &_tmp30_, &_tmp31_);
						_vala_token_begin = _tmp30_;
						_vala_token_end = _tmp31_;
						result = _tmp32_;
						if (token_begin) {
							*token_begin = _vala_token_begin;
						}
						if (token_end) {
							*token_end = _vala_token_end;
						}
						return result;
					} else {
						gchar* _tmp33_;
						gchar _tmp34_;
						_tmp33_ = self->priv->current;
						_tmp34_ = _tmp33_[0];
						if (_tmp34_ == '$') {
							gchar* _tmp35_;
							ValaGenieScannerState* _tmp36_;
							gint _tmp36__length1;
							type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
							_tmp35_ = self->priv->current;
							self->priv->current = _tmp35_ + 1;
							_tmp36_ = self->priv->state_stack;
							_tmp36__length1 = self->priv->state_stack_length1;
							_vala_array_add4 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
						} else {
							ValaSourceReference* _tmp37_;
							ValaSourceReference* _tmp38_;
							ValaSourceLocation _tmp39_ = {0};
							ValaSourceLocation _tmp40_ = {0};
							ValaGenieTokenType _tmp41_;
							_tmp37_ = vala_genie_scanner_get_source_reference (self, 1, 0);
							_tmp38_ = _tmp37_;
							vala_report_error (_tmp38_, "unexpected character");
							_vala_source_reference_unref0 (_tmp38_);
							_tmp41_ = vala_genie_scanner_read_template_token (self, &_tmp39_, &_tmp40_);
							_vala_token_begin = _tmp39_;
							_vala_token_end = _tmp40_;
							result = _tmp41_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
				break;
			}
			default:
			{
				gchar* _tmp87_;
				gchar* _tmp88_;
				ValaGenieScannerState* _tmp96_;
				gint _tmp96__length1;
				type = VALA_GENIE_TOKEN_TYPE_TEMPLATE_STRING_LITERAL;
				token_length_in_chars = 0;
				while (TRUE) {
					gboolean _tmp42_ = FALSE;
					gboolean _tmp43_ = FALSE;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp50_;
					gchar _tmp51_;
					_tmp44_ = self->priv->current;
					_tmp45_ = self->priv->end;
					if (_tmp44_ < _tmp45_) {
						gchar* _tmp46_;
						gchar _tmp47_;
						_tmp46_ = self->priv->current;
						_tmp47_ = _tmp46_[0];
						_tmp43_ = _tmp47_ != '"';
					} else {
						_tmp43_ = FALSE;
					}
					if (_tmp43_) {
						gchar* _tmp48_;
						gchar _tmp49_;
						_tmp48_ = self->priv->current;
						_tmp49_ = _tmp48_[0];
						_tmp42_ = _tmp49_ != '$';
					} else {
						_tmp42_ = FALSE;
					}
					if (!_tmp42_) {
						break;
					}
					_tmp50_ = self->priv->current;
					_tmp51_ = _tmp50_[0];
					if (_tmp51_ == '\\') {
						gchar* _tmp52_;
						gint _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						gchar* _tmp56_;
						gchar _tmp57_;
						_tmp52_ = self->priv->current;
						self->priv->current = _tmp52_ + 1;
						_tmp53_ = token_length_in_chars;
						token_length_in_chars = _tmp53_ + 1;
						_tmp54_ = self->priv->current;
						_tmp55_ = self->priv->end;
						if (_tmp54_ >= _tmp55_) {
							break;
						}
						_tmp56_ = self->priv->current;
						_tmp57_ = _tmp56_[0];
						switch (_tmp57_) {
							case '\'':
							case '"':
							case '\\':
							case '0':
							case 'b':
							case 'f':
							case 'n':
							case 'r':
							case 't':
							{
								gchar* _tmp58_;
								gint _tmp59_;
								_tmp58_ = self->priv->current;
								self->priv->current = _tmp58_ + 1;
								_tmp59_ = token_length_in_chars;
								token_length_in_chars = _tmp59_ + 1;
								break;
							}
							case 'x':
							{
								gchar* _tmp60_;
								gint _tmp61_;
								_tmp60_ = self->priv->current;
								self->priv->current = _tmp60_ + 1;
								_tmp61_ = token_length_in_chars;
								token_length_in_chars = _tmp61_ + 1;
								while (TRUE) {
									gboolean _tmp62_ = FALSE;
									gchar* _tmp63_;
									gchar* _tmp64_;
									gchar* _tmp67_;
									gint _tmp68_;
									_tmp63_ = self->priv->current;
									_tmp64_ = self->priv->end;
									if (_tmp63_ < _tmp64_) {
										gchar* _tmp65_;
										gchar _tmp66_;
										_tmp65_ = self->priv->current;
										_tmp66_ = _tmp65_[0];
										_tmp62_ = g_ascii_isxdigit (_tmp66_);
									} else {
										_tmp62_ = FALSE;
									}
									if (!_tmp62_) {
										break;
									}
									_tmp67_ = self->priv->current;
									self->priv->current = _tmp67_ + 1;
									_tmp68_ = token_length_in_chars;
									token_length_in_chars = _tmp68_ + 1;
								}
								break;
							}
							default:
							{
								gint _tmp69_;
								ValaSourceReference* _tmp70_;
								ValaSourceReference* _tmp71_;
								_tmp69_ = token_length_in_chars;
								_tmp70_ = vala_genie_scanner_get_source_reference (self, _tmp69_, 0);
								_tmp71_ = _tmp70_;
								vala_report_error (_tmp71_, "invalid escape sequence");
								_vala_source_reference_unref0 (_tmp71_);
								break;
							}
						}
					} else {
						gchar* _tmp72_;
						gchar _tmp73_;
						_tmp72_ = self->priv->current;
						_tmp73_ = _tmp72_[0];
						if (_tmp73_ == '\n') {
							gchar* _tmp74_;
							gint _tmp75_;
							_tmp74_ = self->priv->current;
							self->priv->current = _tmp74_ + 1;
							_tmp75_ = self->priv->line;
							self->priv->line = _tmp75_ + 1;
							self->priv->column = 1;
							token_length_in_chars = 1;
						} else {
							gunichar u = 0U;
							gchar* _tmp76_;
							gchar* _tmp77_;
							gchar* _tmp78_;
							gunichar _tmp79_;
							_tmp76_ = self->priv->current;
							_tmp77_ = self->priv->end;
							_tmp78_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp76_, (gssize) ((glong) (_tmp77_ - _tmp78_)));
							_tmp79_ = u;
							if (_tmp79_ != ((gunichar) -1)) {
								gchar* _tmp80_;
								gunichar _tmp81_;
								gint _tmp82_;
								_tmp80_ = self->priv->current;
								_tmp81_ = u;
								self->priv->current = _tmp80_ + g_unichar_to_utf8 (_tmp81_, NULL);
								_tmp82_ = token_length_in_chars;
								token_length_in_chars = _tmp82_ + 1;
							} else {
								gchar* _tmp83_;
								gint _tmp84_;
								ValaSourceReference* _tmp85_;
								ValaSourceReference* _tmp86_;
								_tmp83_ = self->priv->current;
								self->priv->current = _tmp83_ + 1;
								_tmp84_ = token_length_in_chars;
								_tmp85_ = vala_genie_scanner_get_source_reference (self, _tmp84_, 0);
								_tmp86_ = _tmp85_;
								vala_report_error (_tmp86_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp86_);
							}
						}
					}
				}
				_tmp87_ = self->priv->current;
				_tmp88_ = self->priv->end;
				if (_tmp87_ >= _tmp88_) {
					gint _tmp89_;
					ValaSourceReference* _tmp90_;
					ValaSourceReference* _tmp91_;
					gint _tmp92_;
					ValaSourceLocation _tmp93_ = {0};
					ValaSourceLocation _tmp94_ = {0};
					ValaGenieTokenType _tmp95_;
					_tmp89_ = token_length_in_chars;
					_tmp90_ = vala_genie_scanner_get_source_reference (self, _tmp89_, 0);
					_tmp91_ = _tmp90_;
					vala_report_error (_tmp91_, "syntax error, expected \"");
					_vala_source_reference_unref0 (_tmp91_);
					_tmp92_ = self->priv->state_stack_length1;
					self->priv->state_stack_length1 = _tmp92_ - 1;
					_tmp95_ = vala_genie_scanner_read_token (self, &_tmp93_, &_tmp94_);
					_vala_token_begin = _tmp93_;
					_vala_token_end = _tmp94_;
					result = _tmp95_;
					if (token_begin) {
						*token_begin = _vala_token_begin;
					}
					if (token_end) {
						*token_end = _vala_token_end;
					}
					return result;
				}
				_tmp96_ = self->priv->state_stack;
				_tmp96__length1 = self->priv->state_stack_length1;
				_vala_array_add5 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE_PART);
				break;
			}
		}
	}
	_tmp97_ = token_length_in_chars;
	if (_tmp97_ < 0) {
		gint _tmp98_;
		gchar* _tmp99_;
		gchar* _tmp100_;
		_tmp98_ = self->priv->column;
		_tmp99_ = self->priv->current;
		_tmp100_ = begin;
		self->priv->column = _tmp98_ + ((gint) (_tmp99_ - _tmp100_));
	} else {
		gint _tmp101_;
		gint _tmp102_;
		_tmp101_ = self->priv->column;
		_tmp102_ = token_length_in_chars;
		self->priv->column = _tmp101_ + _tmp102_;
	}
	_tmp103_ = self->priv->current;
	_tmp104_ = self->priv->line;
	_tmp105_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp103_, _tmp104_, _tmp105_ - 1);
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static void
_vala_array_add6 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add7 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add8 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add9 (ValaGenieScannerState* * array,
                  int* length,
                  int* size,
                  ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void
_vala_array_add10 (ValaGenieScannerState* * array,
                   int* length,
                   int* size,
                   ValaGenieScannerState value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerState, *array, *size);
	}
	(*array)[(*length)++] = value;
}


ValaGenieTokenType
vala_genie_scanner_read_token (ValaGenieScanner* self,
                               ValaSourceLocation* token_begin,
                               ValaSourceLocation* token_end)
{
	ValaSourceLocation _vala_token_begin = {0};
	ValaSourceLocation _vala_token_end = {0};
	ValaGenieTokenType result = 0;
	gchar* _tmp0_;
	gint _tmp20_;
	gboolean _tmp29_ = FALSE;
	gint _tmp30_;
	gboolean _tmp53_ = FALSE;
	gboolean _tmp54_ = FALSE;
	gboolean _tmp55_ = FALSE;
	ValaGenieTokenType type = 0;
	gchar* begin = NULL;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gint _tmp85_;
	gint _tmp86_;
	gint token_length_in_chars = 0;
	gchar* _tmp87_;
	gchar* _tmp88_;
	gint _tmp497_;
	gchar* _tmp503_;
	gint _tmp504_;
	gint _tmp505_;
	ValaGenieTokenType _tmp506_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->current;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->line;
		_tmp3_ = self->priv->column;
		vala_source_location_init (&_vala_token_begin, _tmp1_, _tmp2_, _tmp3_);
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->line;
		_tmp6_ = self->priv->column;
		vala_source_location_init (&_vala_token_end, _tmp4_, _tmp5_, _tmp6_);
		result = VALA_GENIE_TOKEN_TYPE_EOF;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	if (vala_genie_scanner_in_template (self)) {
		ValaSourceLocation _tmp7_ = {0};
		ValaSourceLocation _tmp8_ = {0};
		ValaGenieTokenType _tmp9_;
		_tmp9_ = vala_genie_scanner_read_template_token (self, &_tmp7_, &_tmp8_);
		_vala_token_begin = _tmp7_;
		_vala_token_end = _tmp8_;
		result = _tmp9_;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	} else {
		if (vala_genie_scanner_in_template_part (self)) {
			gint _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp10_ = self->priv->state_stack_length1;
			self->priv->state_stack_length1 = _tmp10_ - 1;
			_tmp11_ = self->priv->current;
			_tmp12_ = self->priv->line;
			_tmp13_ = self->priv->column;
			vala_source_location_init (&_vala_token_begin, _tmp11_, _tmp12_, _tmp13_);
			_tmp14_ = self->priv->current;
			_tmp15_ = self->priv->line;
			_tmp16_ = self->priv->column;
			vala_source_location_init (&_vala_token_end, _tmp14_, _tmp15_, _tmp16_ - 1);
			result = VALA_GENIE_TOKEN_TYPE_COMMA;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			if (vala_genie_scanner_in_regex_literal (self)) {
				ValaSourceLocation _tmp17_ = {0};
				ValaSourceLocation _tmp18_ = {0};
				ValaGenieTokenType _tmp19_;
				_tmp19_ = vala_genie_scanner_read_regex_token (self, &_tmp17_, &_tmp18_);
				_vala_token_begin = _tmp17_;
				_vala_token_end = _tmp18_;
				result = _tmp19_;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	_tmp20_ = self->priv->pending_dedents;
	if (_tmp20_ > 0) {
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gchar* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp21_ = self->priv->pending_dedents;
		self->priv->pending_dedents = _tmp21_ - 1;
		_tmp22_ = self->priv->indent_level;
		self->priv->indent_level = _tmp22_ - 1;
		_tmp23_ = self->priv->current;
		_tmp24_ = self->priv->line;
		_tmp25_ = self->priv->column;
		vala_source_location_init (&_vala_token_begin, _tmp23_, _tmp24_, _tmp25_);
		_tmp26_ = self->priv->current;
		_tmp27_ = self->priv->line;
		_tmp28_ = self->priv->column;
		vala_source_location_init (&_vala_token_end, _tmp26_, _tmp27_, _tmp28_);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
		result = VALA_GENIE_TOKEN_TYPE_DEDENT;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	_tmp30_ = self->priv->_indent_spaces;
	if (_tmp30_ == 0) {
		_tmp29_ = TRUE;
	} else {
		ValaGenieTokenType _tmp31_;
		_tmp31_ = self->priv->last_token;
		_tmp29_ = _tmp31_ != VALA_GENIE_TOKEN_TYPE_EOL;
	}
	if (_tmp29_) {
		vala_genie_scanner_space (self);
	}
	while (TRUE) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_ = FALSE;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp40_;
		gint _tmp41_;
		_tmp34_ = self->priv->current;
		_tmp35_ = self->priv->end;
		if (_tmp34_ < _tmp35_) {
			gchar* _tmp36_;
			gchar _tmp37_;
			_tmp36_ = self->priv->current;
			_tmp37_ = _tmp36_[0];
			_tmp33_ = _tmp37_ == '\\';
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			gchar* _tmp38_;
			gchar _tmp39_;
			_tmp38_ = self->priv->current;
			_tmp39_ = _tmp38_[1];
			_tmp32_ = _tmp39_ == '\n';
		} else {
			_tmp32_ = FALSE;
		}
		if (!_tmp32_) {
			break;
		}
		_tmp40_ = self->priv->current;
		self->priv->current = _tmp40_ + 2;
		_tmp41_ = self->priv->line;
		self->priv->line = _tmp41_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	while (TRUE) {
		gboolean _tmp42_ = FALSE;
		gboolean _tmp43_ = FALSE;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp51_;
		gint _tmp52_;
		_tmp44_ = self->priv->current;
		_tmp45_ = self->priv->end;
		if (_tmp44_ < _tmp45_) {
			gchar* _tmp46_;
			gchar _tmp47_;
			_tmp46_ = self->priv->current;
			_tmp47_ = _tmp46_[0];
			_tmp43_ = _tmp47_ == '\n';
		} else {
			_tmp43_ = FALSE;
		}
		if (_tmp43_) {
			gboolean _tmp48_ = FALSE;
			gint _tmp49_;
			_tmp49_ = self->priv->open_parens_count;
			if (_tmp49_ > 0) {
				_tmp48_ = TRUE;
			} else {
				gint _tmp50_;
				_tmp50_ = self->priv->open_brace_count;
				_tmp48_ = _tmp50_ > 0;
			}
			_tmp42_ = _tmp48_;
		} else {
			_tmp42_ = FALSE;
		}
		if (!_tmp42_) {
			break;
		}
		_tmp51_ = self->priv->current;
		self->priv->current = _tmp51_ + 1;
		_tmp52_ = self->priv->line;
		self->priv->line = _tmp52_ + 1;
		vala_genie_scanner_skip_space_tabs (self);
	}
	if (vala_genie_scanner_newline (self)) {
		gboolean _tmp56_;
		_tmp56_ = self->priv->parse_started;
		_tmp55_ = _tmp56_;
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaGenieTokenType _tmp57_;
		_tmp57_ = self->priv->last_token;
		_tmp54_ = _tmp57_ != VALA_GENIE_TOKEN_TYPE_EOL;
	} else {
		_tmp54_ = FALSE;
	}
	if (_tmp54_) {
		ValaGenieTokenType _tmp58_;
		_tmp58_ = self->priv->last_token;
		_tmp53_ = _tmp58_ != VALA_GENIE_TOKEN_TYPE_SEMICOLON;
	} else {
		_tmp53_ = FALSE;
	}
	if (_tmp53_) {
		gchar* _tmp59_;
		gint _tmp60_;
		gint _tmp61_;
		gchar* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		_tmp59_ = self->priv->current;
		_tmp60_ = self->priv->line;
		_tmp61_ = self->priv->column;
		vala_source_location_init (&_vala_token_begin, _tmp59_, _tmp60_, _tmp61_);
		_tmp62_ = self->priv->current;
		_tmp63_ = self->priv->line;
		_tmp64_ = self->priv->column;
		vala_source_location_init (&_vala_token_end, _tmp62_, _tmp63_, _tmp64_);
		self->priv->last_token = VALA_GENIE_TOKEN_TYPE_EOL;
		result = VALA_GENIE_TOKEN_TYPE_EOL;
		if (token_begin) {
			*token_begin = _vala_token_begin;
		}
		if (token_end) {
			*token_end = _vala_token_end;
		}
		return result;
	}
	while (TRUE) {
		gchar* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		if (!vala_genie_scanner_skip_newlines (self)) {
			break;
		}
		_tmp65_ = self->priv->current;
		_tmp66_ = self->priv->line;
		_tmp67_ = self->priv->column;
		vala_source_location_init (&_vala_token_begin, _tmp65_, _tmp66_, _tmp67_);
		self->priv->current_indent_level = vala_genie_scanner_count_tabs (self);
		_tmp68_ = self->priv->current_indent_level;
		if (_tmp68_ == -1) {
			continue;
		}
		_tmp69_ = self->priv->current_indent_level;
		_tmp70_ = self->priv->indent_level;
		if (_tmp69_ > _tmp70_) {
			gint _tmp71_;
			gchar* _tmp72_;
			gint _tmp73_;
			gint _tmp74_;
			_tmp71_ = self->priv->current_indent_level;
			self->priv->indent_level = _tmp71_;
			_tmp72_ = self->priv->current;
			_tmp73_ = self->priv->line;
			_tmp74_ = self->priv->column;
			vala_source_location_init (&_vala_token_end, _tmp72_, _tmp73_, _tmp74_);
			self->priv->last_token = VALA_GENIE_TOKEN_TYPE_INDENT;
			result = VALA_GENIE_TOKEN_TYPE_INDENT;
			if (token_begin) {
				*token_begin = _vala_token_begin;
			}
			if (token_end) {
				*token_end = _vala_token_end;
			}
			return result;
		} else {
			gint _tmp75_;
			gint _tmp76_;
			_tmp75_ = self->priv->current_indent_level;
			_tmp76_ = self->priv->indent_level;
			if (_tmp75_ < _tmp76_) {
				gint _tmp77_;
				gint _tmp78_;
				gint _tmp79_;
				gchar* _tmp80_;
				gint _tmp81_;
				gint _tmp82_;
				_tmp77_ = self->priv->indent_level;
				self->priv->indent_level = _tmp77_ - 1;
				_tmp78_ = self->priv->indent_level;
				_tmp79_ = self->priv->current_indent_level;
				self->priv->pending_dedents = _tmp78_ - _tmp79_;
				_tmp80_ = self->priv->current;
				_tmp81_ = self->priv->line;
				_tmp82_ = self->priv->column;
				vala_source_location_init (&_vala_token_end, _tmp80_, _tmp81_, _tmp82_);
				self->priv->last_token = VALA_GENIE_TOKEN_TYPE_DEDENT;
				result = VALA_GENIE_TOKEN_TYPE_DEDENT;
				if (token_begin) {
					*token_begin = _vala_token_begin;
				}
				if (token_end) {
					*token_end = _vala_token_end;
				}
				return result;
			}
		}
	}
	_tmp83_ = self->priv->current;
	begin = _tmp83_;
	_tmp84_ = begin;
	_tmp85_ = self->priv->line;
	_tmp86_ = self->priv->column;
	vala_source_location_init (&_vala_token_begin, _tmp84_, _tmp85_, _tmp86_);
	token_length_in_chars = -1;
	self->priv->parse_started = TRUE;
	_tmp87_ = self->priv->current;
	_tmp88_ = self->priv->end;
	if (_tmp87_ >= _tmp88_) {
		gint _tmp89_;
		_tmp89_ = self->priv->indent_level;
		if (_tmp89_ > 0) {
			gint _tmp90_;
			gint _tmp91_;
			_tmp90_ = self->priv->indent_level;
			self->priv->indent_level = _tmp90_ - 1;
			_tmp91_ = self->priv->indent_level;
			self->priv->pending_dedents = _tmp91_;
			type = VALA_GENIE_TOKEN_TYPE_DEDENT;
		} else {
			type = VALA_GENIE_TOKEN_TYPE_EOF;
		}
	} else {
		gboolean _tmp92_ = FALSE;
		gchar* _tmp93_;
		gchar _tmp94_;
		_tmp93_ = self->priv->current;
		_tmp94_ = _tmp93_[0];
		if (g_ascii_isalpha (_tmp94_)) {
			_tmp92_ = TRUE;
		} else {
			gchar* _tmp95_;
			gchar _tmp96_;
			_tmp95_ = self->priv->current;
			_tmp96_ = _tmp95_[0];
			_tmp92_ = _tmp96_ == '_';
		}
		if (_tmp92_) {
			gint len = 0;
			gchar* _tmp104_;
			gint _tmp105_;
			len = 0;
			while (TRUE) {
				gboolean _tmp97_ = FALSE;
				gchar* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp102_;
				gint _tmp103_;
				_tmp98_ = self->priv->current;
				_tmp99_ = self->priv->end;
				if (_tmp98_ < _tmp99_) {
					gchar* _tmp100_;
					gchar _tmp101_;
					_tmp100_ = self->priv->current;
					_tmp101_ = _tmp100_[0];
					_tmp97_ = vala_genie_scanner_is_ident_char (self, _tmp101_);
				} else {
					_tmp97_ = FALSE;
				}
				if (!_tmp97_) {
					break;
				}
				_tmp102_ = self->priv->current;
				self->priv->current = _tmp102_ + 1;
				_tmp103_ = len;
				len = _tmp103_ + 1;
			}
			_tmp104_ = begin;
			_tmp105_ = len;
			type = vala_genie_scanner_get_identifier_or_keyword (_tmp104_, _tmp105_);
		} else {
			gchar* _tmp106_;
			gchar _tmp107_;
			_tmp106_ = self->priv->current;
			_tmp107_ = _tmp106_[0];
			if (_tmp107_ == '@') {
				gboolean _tmp108_ = FALSE;
				gchar* _tmp109_;
				gchar* _tmp110_;
				_tmp109_ = self->priv->current;
				_tmp110_ = self->priv->end;
				if (_tmp109_ < (_tmp110_ - 1)) {
					gchar* _tmp111_;
					gchar _tmp112_;
					_tmp111_ = self->priv->current;
					_tmp112_ = _tmp111_[1];
					_tmp108_ = _tmp112_ == '"';
				} else {
					_tmp108_ = FALSE;
				}
				if (_tmp108_) {
					gchar* _tmp113_;
					ValaGenieScannerState* _tmp114_;
					gint _tmp114__length1;
					type = VALA_GENIE_TOKEN_TYPE_OPEN_TEMPLATE;
					_tmp113_ = self->priv->current;
					self->priv->current = _tmp113_ + 2;
					_tmp114_ = self->priv->state_stack;
					_tmp114__length1 = self->priv->state_stack_length1;
					_vala_array_add6 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_TEMPLATE);
				} else {
					gchar* _tmp115_;
					gchar* _tmp116_;
					gint len = 0;
					_tmp115_ = _vala_token_begin.pos;
					_vala_token_begin.pos = _tmp115_ + 1;
					_tmp116_ = self->priv->current;
					self->priv->current = _tmp116_ + 1;
					len = 0;
					while (TRUE) {
						gboolean _tmp117_ = FALSE;
						gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp122_;
						gint _tmp123_;
						_tmp118_ = self->priv->current;
						_tmp119_ = self->priv->end;
						if (_tmp118_ < _tmp119_) {
							gchar* _tmp120_;
							gchar _tmp121_;
							_tmp120_ = self->priv->current;
							_tmp121_ = _tmp120_[0];
							_tmp117_ = vala_genie_scanner_is_ident_char (self, _tmp121_);
						} else {
							_tmp117_ = FALSE;
						}
						if (!_tmp117_) {
							break;
						}
						_tmp122_ = self->priv->current;
						self->priv->current = _tmp122_ + 1;
						_tmp123_ = len;
						len = _tmp123_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
				}
			} else {
				gchar* _tmp124_;
				gchar _tmp125_;
				_tmp124_ = self->priv->current;
				_tmp125_ = _tmp124_[0];
				if (g_ascii_isdigit (_tmp125_)) {
					gboolean _tmp132_ = FALSE;
					gchar* _tmp133_;
					gchar* _tmp134_;
					while (TRUE) {
						gboolean _tmp126_ = FALSE;
						gchar* _tmp127_;
						gchar* _tmp128_;
						gchar* _tmp131_;
						_tmp127_ = self->priv->current;
						_tmp128_ = self->priv->end;
						if (_tmp127_ < _tmp128_) {
							gchar* _tmp129_;
							gchar _tmp130_;
							_tmp129_ = self->priv->current;
							_tmp130_ = _tmp129_[0];
							_tmp126_ = g_ascii_isdigit (_tmp130_);
						} else {
							_tmp126_ = FALSE;
						}
						if (!_tmp126_) {
							break;
						}
						_tmp131_ = self->priv->current;
						self->priv->current = _tmp131_ + 1;
					}
					type = VALA_GENIE_TOKEN_TYPE_INTEGER_LITERAL;
					_tmp133_ = self->priv->current;
					_tmp134_ = self->priv->end;
					if (_tmp133_ < _tmp134_) {
						gchar* _tmp135_;
						gchar _tmp136_;
						_tmp135_ = self->priv->current;
						_tmp136_ = _tmp135_[0];
						_tmp132_ = g_ascii_tolower (_tmp136_) == 'l';
					} else {
						_tmp132_ = FALSE;
					}
					if (_tmp132_) {
						gchar* _tmp137_;
						gboolean _tmp138_ = FALSE;
						gchar* _tmp139_;
						gchar* _tmp140_;
						_tmp137_ = self->priv->current;
						self->priv->current = _tmp137_ + 1;
						_tmp139_ = self->priv->current;
						_tmp140_ = self->priv->end;
						if (_tmp139_ < _tmp140_) {
							gchar* _tmp141_;
							gchar _tmp142_;
							_tmp141_ = self->priv->current;
							_tmp142_ = _tmp141_[0];
							_tmp138_ = g_ascii_tolower (_tmp142_) == 'l';
						} else {
							_tmp138_ = FALSE;
						}
						if (_tmp138_) {
							gchar* _tmp143_;
							_tmp143_ = self->priv->current;
							self->priv->current = _tmp143_ + 1;
						}
					} else {
						gboolean _tmp144_ = FALSE;
						gchar* _tmp145_;
						gchar* _tmp146_;
						_tmp145_ = self->priv->current;
						_tmp146_ = self->priv->end;
						if (_tmp145_ < _tmp146_) {
							gchar* _tmp147_;
							gchar _tmp148_;
							_tmp147_ = self->priv->current;
							_tmp148_ = _tmp147_[0];
							_tmp144_ = g_ascii_tolower (_tmp148_) == 'u';
						} else {
							_tmp144_ = FALSE;
						}
						if (_tmp144_) {
							gchar* _tmp149_;
							gboolean _tmp150_ = FALSE;
							gchar* _tmp151_;
							gchar* _tmp152_;
							_tmp149_ = self->priv->current;
							self->priv->current = _tmp149_ + 1;
							_tmp151_ = self->priv->current;
							_tmp152_ = self->priv->end;
							if (_tmp151_ < _tmp152_) {
								gchar* _tmp153_;
								gchar _tmp154_;
								_tmp153_ = self->priv->current;
								_tmp154_ = _tmp153_[0];
								_tmp150_ = g_ascii_tolower (_tmp154_) == 'l';
							} else {
								_tmp150_ = FALSE;
							}
							if (_tmp150_) {
								gchar* _tmp155_;
								gboolean _tmp156_ = FALSE;
								gchar* _tmp157_;
								gchar* _tmp158_;
								_tmp155_ = self->priv->current;
								self->priv->current = _tmp155_ + 1;
								_tmp157_ = self->priv->current;
								_tmp158_ = self->priv->end;
								if (_tmp157_ < _tmp158_) {
									gchar* _tmp159_;
									gchar _tmp160_;
									_tmp159_ = self->priv->current;
									_tmp160_ = _tmp159_[0];
									_tmp156_ = g_ascii_tolower (_tmp160_) == 'l';
								} else {
									_tmp156_ = FALSE;
								}
								if (_tmp156_) {
									gchar* _tmp161_;
									_tmp161_ = self->priv->current;
									self->priv->current = _tmp161_ + 1;
								}
							}
						} else {
							gboolean _tmp162_ = FALSE;
							gboolean _tmp163_ = FALSE;
							gchar* _tmp164_;
							gchar* _tmp165_;
							_tmp164_ = self->priv->current;
							_tmp165_ = self->priv->end;
							if (_tmp164_ < (_tmp165_ - 1)) {
								gchar* _tmp166_;
								gchar _tmp167_;
								_tmp166_ = self->priv->current;
								_tmp167_ = _tmp166_[0];
								_tmp163_ = _tmp167_ == '.';
							} else {
								_tmp163_ = FALSE;
							}
							if (_tmp163_) {
								gchar* _tmp168_;
								gchar _tmp169_;
								_tmp168_ = self->priv->current;
								_tmp169_ = _tmp168_[1];
								_tmp162_ = g_ascii_isdigit (_tmp169_);
							} else {
								_tmp162_ = FALSE;
							}
							if (_tmp162_) {
								gchar* _tmp170_;
								gboolean _tmp177_ = FALSE;
								gchar* _tmp178_;
								gchar* _tmp179_;
								gboolean _tmp198_ = FALSE;
								gchar* _tmp199_;
								gchar* _tmp200_;
								_tmp170_ = self->priv->current;
								self->priv->current = _tmp170_ + 1;
								while (TRUE) {
									gboolean _tmp171_ = FALSE;
									gchar* _tmp172_;
									gchar* _tmp173_;
									gchar* _tmp176_;
									_tmp172_ = self->priv->current;
									_tmp173_ = self->priv->end;
									if (_tmp172_ < _tmp173_) {
										gchar* _tmp174_;
										gchar _tmp175_;
										_tmp174_ = self->priv->current;
										_tmp175_ = _tmp174_[0];
										_tmp171_ = g_ascii_isdigit (_tmp175_);
									} else {
										_tmp171_ = FALSE;
									}
									if (!_tmp171_) {
										break;
									}
									_tmp176_ = self->priv->current;
									self->priv->current = _tmp176_ + 1;
								}
								_tmp178_ = self->priv->current;
								_tmp179_ = self->priv->end;
								if (_tmp178_ < _tmp179_) {
									gchar* _tmp180_;
									gchar _tmp181_;
									_tmp180_ = self->priv->current;
									_tmp181_ = _tmp180_[0];
									_tmp177_ = g_ascii_tolower (_tmp181_) == 'e';
								} else {
									_tmp177_ = FALSE;
								}
								if (_tmp177_) {
									gchar* _tmp182_;
									gboolean _tmp183_ = FALSE;
									gchar* _tmp184_;
									gchar* _tmp185_;
									_tmp182_ = self->priv->current;
									self->priv->current = _tmp182_ + 1;
									_tmp184_ = self->priv->current;
									_tmp185_ = self->priv->end;
									if (_tmp184_ < _tmp185_) {
										gboolean _tmp186_ = FALSE;
										gchar* _tmp187_;
										gchar _tmp188_;
										_tmp187_ = self->priv->current;
										_tmp188_ = _tmp187_[0];
										if (_tmp188_ == '+') {
											_tmp186_ = TRUE;
										} else {
											gchar* _tmp189_;
											gchar _tmp190_;
											_tmp189_ = self->priv->current;
											_tmp190_ = _tmp189_[0];
											_tmp186_ = _tmp190_ == '-';
										}
										_tmp183_ = _tmp186_;
									} else {
										_tmp183_ = FALSE;
									}
									if (_tmp183_) {
										gchar* _tmp191_;
										_tmp191_ = self->priv->current;
										self->priv->current = _tmp191_ + 1;
									}
									while (TRUE) {
										gboolean _tmp192_ = FALSE;
										gchar* _tmp193_;
										gchar* _tmp194_;
										gchar* _tmp197_;
										_tmp193_ = self->priv->current;
										_tmp194_ = self->priv->end;
										if (_tmp193_ < _tmp194_) {
											gchar* _tmp195_;
											gchar _tmp196_;
											_tmp195_ = self->priv->current;
											_tmp196_ = _tmp195_[0];
											_tmp192_ = g_ascii_isdigit (_tmp196_);
										} else {
											_tmp192_ = FALSE;
										}
										if (!_tmp192_) {
											break;
										}
										_tmp197_ = self->priv->current;
										self->priv->current = _tmp197_ + 1;
									}
								}
								_tmp199_ = self->priv->current;
								_tmp200_ = self->priv->end;
								if (_tmp199_ < _tmp200_) {
									gchar* _tmp201_;
									gchar _tmp202_;
									_tmp201_ = self->priv->current;
									_tmp202_ = _tmp201_[0];
									_tmp198_ = g_ascii_tolower (_tmp202_) == 'f';
								} else {
									_tmp198_ = FALSE;
								}
								if (_tmp198_) {
									gchar* _tmp203_;
									_tmp203_ = self->priv->current;
									self->priv->current = _tmp203_ + 1;
								}
								type = VALA_GENIE_TOKEN_TYPE_REAL_LITERAL;
							} else {
								gboolean _tmp204_ = FALSE;
								gboolean _tmp205_ = FALSE;
								gboolean _tmp206_ = FALSE;
								gboolean _tmp207_ = FALSE;
								gchar* _tmp208_;
								gchar* _tmp209_;
								_tmp208_ = self->priv->current;
								_tmp209_ = self->priv->end;
								if (_tmp208_ < _tmp209_) {
									gchar* _tmp210_;
									gchar* _tmp211_;
									_tmp210_ = self->priv->current;
									_tmp211_ = begin;
									_tmp207_ = _tmp210_ == (_tmp211_ + 1);
								} else {
									_tmp207_ = FALSE;
								}
								if (_tmp207_) {
									gchar* _tmp212_;
									gchar _tmp213_;
									_tmp212_ = begin;
									_tmp213_ = _tmp212_[0];
									_tmp206_ = _tmp213_ == '0';
								} else {
									_tmp206_ = FALSE;
								}
								if (_tmp206_) {
									gchar* _tmp214_;
									gchar _tmp215_;
									_tmp214_ = begin;
									_tmp215_ = _tmp214_[1];
									_tmp205_ = _tmp215_ == 'x';
								} else {
									_tmp205_ = FALSE;
								}
								if (_tmp205_) {
									gchar* _tmp216_;
									gchar _tmp217_;
									_tmp216_ = begin;
									_tmp217_ = _tmp216_[2];
									_tmp204_ = g_ascii_isxdigit (_tmp217_);
								} else {
									_tmp204_ = FALSE;
								}
								if (_tmp204_) {
									gchar* _tmp218_;
									_tmp218_ = self->priv->current;
									self->priv->current = _tmp218_ + 1;
									while (TRUE) {
										gboolean _tmp219_ = FALSE;
										gchar* _tmp220_;
										gchar* _tmp221_;
										gchar* _tmp224_;
										_tmp220_ = self->priv->current;
										_tmp221_ = self->priv->end;
										if (_tmp220_ < _tmp221_) {
											gchar* _tmp222_;
											gchar _tmp223_;
											_tmp222_ = self->priv->current;
											_tmp223_ = _tmp222_[0];
											_tmp219_ = g_ascii_isxdigit (_tmp223_);
										} else {
											_tmp219_ = FALSE;
										}
										if (!_tmp219_) {
											break;
										}
										_tmp224_ = self->priv->current;
										self->priv->current = _tmp224_ + 1;
									}
								} else {
									gboolean _tmp225_ = FALSE;
									gchar* _tmp226_;
									gchar* _tmp227_;
									_tmp226_ = self->priv->current;
									_tmp227_ = self->priv->end;
									if (_tmp226_ < _tmp227_) {
										gchar* _tmp228_;
										gchar _tmp229_;
										_tmp228_ = self->priv->current;
										_tmp229_ = _tmp228_[0];
										_tmp225_ = vala_genie_scanner_is_ident_char (self, _tmp229_);
									} else {
										_tmp225_ = FALSE;
									}
									if (_tmp225_) {
										while (TRUE) {
											gboolean _tmp230_ = FALSE;
											gchar* _tmp231_;
											gchar* _tmp232_;
											gchar* _tmp235_;
											_tmp231_ = self->priv->current;
											_tmp232_ = self->priv->end;
											if (_tmp231_ < _tmp232_) {
												gchar* _tmp233_;
												gchar _tmp234_;
												_tmp233_ = self->priv->current;
												_tmp234_ = _tmp233_[0];
												_tmp230_ = vala_genie_scanner_is_ident_char (self, _tmp234_);
											} else {
												_tmp230_ = FALSE;
											}
											if (!_tmp230_) {
												break;
											}
											_tmp235_ = self->priv->current;
											self->priv->current = _tmp235_ + 1;
										}
										type = VALA_GENIE_TOKEN_TYPE_IDENTIFIER;
									}
								}
							}
						}
					}
				} else {
					gchar* _tmp236_;
					gchar _tmp237_;
					_tmp236_ = self->priv->current;
					_tmp237_ = _tmp236_[0];
					switch (_tmp237_) {
						case '{':
						{
							gint _tmp238_;
							ValaGenieScannerState* _tmp239_;
							gint _tmp239__length1;
							gchar* _tmp240_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACE;
							_tmp238_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp238_ + 1;
							_tmp239_ = self->priv->state_stack;
							_tmp239__length1 = self->priv->state_stack_length1;
							_vala_array_add7 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACE);
							_tmp240_ = self->priv->current;
							self->priv->current = _tmp240_ + 1;
							break;
						}
						case '}':
						{
							gint _tmp241_;
							ValaGenieScannerState* _tmp242_;
							gint _tmp242__length1;
							gchar* _tmp244_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACE;
							_tmp241_ = self->priv->open_brace_count;
							self->priv->open_brace_count = _tmp241_ - 1;
							_tmp242_ = self->priv->state_stack;
							_tmp242__length1 = self->priv->state_stack_length1;
							if (_tmp242__length1 > 0) {
								gint _tmp243_;
								_tmp243_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp243_ - 1;
							}
							_tmp244_ = self->priv->current;
							self->priv->current = _tmp244_ + 1;
							break;
						}
						case '(':
						{
							gint _tmp245_;
							ValaGenieScannerState* _tmp246_;
							gint _tmp246__length1;
							gchar* _tmp247_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_PARENS;
							_tmp245_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp245_ + 1;
							_tmp246_ = self->priv->state_stack;
							_tmp246__length1 = self->priv->state_stack_length1;
							_vala_array_add8 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_PARENS);
							_tmp247_ = self->priv->current;
							self->priv->current = _tmp247_ + 1;
							break;
						}
						case ')':
						{
							gint _tmp248_;
							gchar* _tmp249_;
							ValaGenieScannerState* _tmp250_;
							gint _tmp250__length1;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_PARENS;
							_tmp248_ = self->priv->open_parens_count;
							self->priv->open_parens_count = _tmp248_ - 1;
							_tmp249_ = self->priv->current;
							self->priv->current = _tmp249_ + 1;
							_tmp250_ = self->priv->state_stack;
							_tmp250__length1 = self->priv->state_stack_length1;
							if (_tmp250__length1 > 0) {
								gint _tmp251_;
								_tmp251_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp251_ - 1;
							}
							if (vala_genie_scanner_in_template (self)) {
								type = VALA_GENIE_TOKEN_TYPE_COMMA;
							}
							break;
						}
						case '[':
						{
							ValaGenieScannerState* _tmp252_;
							gint _tmp252__length1;
							gchar* _tmp253_;
							type = VALA_GENIE_TOKEN_TYPE_OPEN_BRACKET;
							_tmp252_ = self->priv->state_stack;
							_tmp252__length1 = self->priv->state_stack_length1;
							_vala_array_add9 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_BRACKET);
							_tmp253_ = self->priv->current;
							self->priv->current = _tmp253_ + 1;
							break;
						}
						case ']':
						{
							ValaGenieScannerState* _tmp254_;
							gint _tmp254__length1;
							gchar* _tmp256_;
							type = VALA_GENIE_TOKEN_TYPE_CLOSE_BRACKET;
							_tmp254_ = self->priv->state_stack;
							_tmp254__length1 = self->priv->state_stack_length1;
							if (_tmp254__length1 > 0) {
								gint _tmp255_;
								_tmp255_ = self->priv->state_stack_length1;
								self->priv->state_stack_length1 = _tmp255_ - 1;
							}
							_tmp256_ = self->priv->current;
							self->priv->current = _tmp256_ + 1;
							break;
						}
						case '.':
						{
							gchar* _tmp257_;
							gchar* _tmp258_;
							gchar* _tmp259_;
							type = VALA_GENIE_TOKEN_TYPE_DOT;
							_tmp257_ = self->priv->current;
							self->priv->current = _tmp257_ + 1;
							_tmp258_ = self->priv->current;
							_tmp259_ = self->priv->end;
							if (_tmp258_ < (_tmp259_ - 1)) {
								gboolean _tmp260_ = FALSE;
								gchar* _tmp261_;
								gchar _tmp262_;
								_tmp261_ = self->priv->current;
								_tmp262_ = _tmp261_[0];
								if (_tmp262_ == '.') {
									gchar* _tmp263_;
									gchar _tmp264_;
									_tmp263_ = self->priv->current;
									_tmp264_ = _tmp263_[1];
									_tmp260_ = _tmp264_ == '.';
								} else {
									_tmp260_ = FALSE;
								}
								if (_tmp260_) {
									gchar* _tmp265_;
									type = VALA_GENIE_TOKEN_TYPE_ELLIPSIS;
									_tmp265_ = self->priv->current;
									self->priv->current = _tmp265_ + 2;
								}
							}
							break;
						}
						case ':':
						{
							gchar* _tmp266_;
							type = VALA_GENIE_TOKEN_TYPE_COLON;
							_tmp266_ = self->priv->current;
							self->priv->current = _tmp266_ + 1;
							break;
						}
						case ',':
						{
							gchar* _tmp267_;
							type = VALA_GENIE_TOKEN_TYPE_COMMA;
							_tmp267_ = self->priv->current;
							self->priv->current = _tmp267_ + 1;
							break;
						}
						case ';':
						{
							gchar* _tmp268_;
							type = VALA_GENIE_TOKEN_TYPE_SEMICOLON;
							_tmp268_ = self->priv->current;
							self->priv->current = _tmp268_ + 1;
							break;
						}
						case '#':
						{
							gchar* _tmp269_;
							type = VALA_GENIE_TOKEN_TYPE_HASH;
							_tmp269_ = self->priv->current;
							self->priv->current = _tmp269_ + 1;
							break;
						}
						case '?':
						{
							gchar* _tmp270_;
							type = VALA_GENIE_TOKEN_TYPE_INTERR;
							_tmp270_ = self->priv->current;
							self->priv->current = _tmp270_ + 1;
							break;
						}
						case '|':
						{
							gchar* _tmp271_;
							gchar* _tmp272_;
							gchar* _tmp273_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_OR;
							_tmp271_ = self->priv->current;
							self->priv->current = _tmp271_ + 1;
							_tmp272_ = self->priv->current;
							_tmp273_ = self->priv->end;
							if (_tmp272_ < _tmp273_) {
								gchar* _tmp274_;
								gchar _tmp275_;
								_tmp274_ = self->priv->current;
								_tmp275_ = _tmp274_[0];
								switch (_tmp275_) {
									case '=':
									{
										gchar* _tmp276_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_OR;
										_tmp276_ = self->priv->current;
										self->priv->current = _tmp276_ + 1;
										break;
									}
									case '|':
									{
										gchar* _tmp277_;
										type = VALA_GENIE_TOKEN_TYPE_OP_OR;
										_tmp277_ = self->priv->current;
										self->priv->current = _tmp277_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '&':
						{
							gchar* _tmp278_;
							gchar* _tmp279_;
							gchar* _tmp280_;
							type = VALA_GENIE_TOKEN_TYPE_BITWISE_AND;
							_tmp278_ = self->priv->current;
							self->priv->current = _tmp278_ + 1;
							_tmp279_ = self->priv->current;
							_tmp280_ = self->priv->end;
							if (_tmp279_ < _tmp280_) {
								gchar* _tmp281_;
								gchar _tmp282_;
								_tmp281_ = self->priv->current;
								_tmp282_ = _tmp281_[0];
								switch (_tmp282_) {
									case '=':
									{
										gchar* _tmp283_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_AND;
										_tmp283_ = self->priv->current;
										self->priv->current = _tmp283_ + 1;
										break;
									}
									case '&':
									{
										gchar* _tmp284_;
										type = VALA_GENIE_TOKEN_TYPE_OP_AND;
										_tmp284_ = self->priv->current;
										self->priv->current = _tmp284_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '^':
						{
							gchar* _tmp285_;
							gboolean _tmp286_ = FALSE;
							gchar* _tmp287_;
							gchar* _tmp288_;
							type = VALA_GENIE_TOKEN_TYPE_CARRET;
							_tmp285_ = self->priv->current;
							self->priv->current = _tmp285_ + 1;
							_tmp287_ = self->priv->current;
							_tmp288_ = self->priv->end;
							if (_tmp287_ < _tmp288_) {
								gchar* _tmp289_;
								gchar _tmp290_;
								_tmp289_ = self->priv->current;
								_tmp290_ = _tmp289_[0];
								_tmp286_ = _tmp290_ == '=';
							} else {
								_tmp286_ = FALSE;
							}
							if (_tmp286_) {
								gchar* _tmp291_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_BITWISE_XOR;
								_tmp291_ = self->priv->current;
								self->priv->current = _tmp291_ + 1;
							}
							break;
						}
						case '~':
						{
							gchar* _tmp292_;
							type = VALA_GENIE_TOKEN_TYPE_TILDE;
							_tmp292_ = self->priv->current;
							self->priv->current = _tmp292_ + 1;
							break;
						}
						case '=':
						{
							gchar* _tmp293_;
							gchar* _tmp294_;
							gchar* _tmp295_;
							type = VALA_GENIE_TOKEN_TYPE_ASSIGN;
							_tmp293_ = self->priv->current;
							self->priv->current = _tmp293_ + 1;
							_tmp294_ = self->priv->current;
							_tmp295_ = self->priv->end;
							if (_tmp294_ < _tmp295_) {
								gchar* _tmp296_;
								gchar _tmp297_;
								_tmp296_ = self->priv->current;
								_tmp297_ = _tmp296_[0];
								switch (_tmp297_) {
									case '=':
									{
										gchar* _tmp298_;
										type = VALA_GENIE_TOKEN_TYPE_OP_EQ;
										_tmp298_ = self->priv->current;
										self->priv->current = _tmp298_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp299_;
										type = VALA_GENIE_TOKEN_TYPE_LAMBDA;
										_tmp299_ = self->priv->current;
										self->priv->current = _tmp299_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '<':
						{
							gchar* _tmp300_;
							gchar* _tmp301_;
							gchar* _tmp302_;
							type = VALA_GENIE_TOKEN_TYPE_OP_LT;
							_tmp300_ = self->priv->current;
							self->priv->current = _tmp300_ + 1;
							_tmp301_ = self->priv->current;
							_tmp302_ = self->priv->end;
							if (_tmp301_ < _tmp302_) {
								gchar* _tmp303_;
								gchar _tmp304_;
								_tmp303_ = self->priv->current;
								_tmp304_ = _tmp303_[0];
								switch (_tmp304_) {
									case '=':
									{
										gchar* _tmp305_;
										type = VALA_GENIE_TOKEN_TYPE_OP_LE;
										_tmp305_ = self->priv->current;
										self->priv->current = _tmp305_ + 1;
										break;
									}
									case '<':
									{
										gchar* _tmp306_;
										gboolean _tmp307_ = FALSE;
										gchar* _tmp308_;
										gchar* _tmp309_;
										type = VALA_GENIE_TOKEN_TYPE_OP_SHIFT_LEFT;
										_tmp306_ = self->priv->current;
										self->priv->current = _tmp306_ + 1;
										_tmp308_ = self->priv->current;
										_tmp309_ = self->priv->end;
										if (_tmp308_ < _tmp309_) {
											gchar* _tmp310_;
											gchar _tmp311_;
											_tmp310_ = self->priv->current;
											_tmp311_ = _tmp310_[0];
											_tmp307_ = _tmp311_ == '=';
										} else {
											_tmp307_ = FALSE;
										}
										if (_tmp307_) {
											gchar* _tmp312_;
											type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SHIFT_LEFT;
											_tmp312_ = self->priv->current;
											self->priv->current = _tmp312_ + 1;
										}
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '>':
						{
							gchar* _tmp313_;
							gboolean _tmp314_ = FALSE;
							gchar* _tmp315_;
							gchar* _tmp316_;
							type = VALA_GENIE_TOKEN_TYPE_OP_GT;
							_tmp313_ = self->priv->current;
							self->priv->current = _tmp313_ + 1;
							_tmp315_ = self->priv->current;
							_tmp316_ = self->priv->end;
							if (_tmp315_ < _tmp316_) {
								gchar* _tmp317_;
								gchar _tmp318_;
								_tmp317_ = self->priv->current;
								_tmp318_ = _tmp317_[0];
								_tmp314_ = _tmp318_ == '=';
							} else {
								_tmp314_ = FALSE;
							}
							if (_tmp314_) {
								gchar* _tmp319_;
								type = VALA_GENIE_TOKEN_TYPE_OP_GE;
								_tmp319_ = self->priv->current;
								self->priv->current = _tmp319_ + 1;
							}
							break;
						}
						case '!':
						{
							gchar* _tmp320_;
							gboolean _tmp321_ = FALSE;
							gchar* _tmp322_;
							gchar* _tmp323_;
							type = VALA_GENIE_TOKEN_TYPE_OP_NEG;
							_tmp320_ = self->priv->current;
							self->priv->current = _tmp320_ + 1;
							_tmp322_ = self->priv->current;
							_tmp323_ = self->priv->end;
							if (_tmp322_ < _tmp323_) {
								gchar* _tmp324_;
								gchar _tmp325_;
								_tmp324_ = self->priv->current;
								_tmp325_ = _tmp324_[0];
								_tmp321_ = _tmp325_ == '=';
							} else {
								_tmp321_ = FALSE;
							}
							if (_tmp321_) {
								gchar* _tmp326_;
								type = VALA_GENIE_TOKEN_TYPE_OP_NE;
								_tmp326_ = self->priv->current;
								self->priv->current = _tmp326_ + 1;
							}
							break;
						}
						case '+':
						{
							gchar* _tmp327_;
							gchar* _tmp328_;
							gchar* _tmp329_;
							type = VALA_GENIE_TOKEN_TYPE_PLUS;
							_tmp327_ = self->priv->current;
							self->priv->current = _tmp327_ + 1;
							_tmp328_ = self->priv->current;
							_tmp329_ = self->priv->end;
							if (_tmp328_ < _tmp329_) {
								gchar* _tmp330_;
								gchar _tmp331_;
								_tmp330_ = self->priv->current;
								_tmp331_ = _tmp330_[0];
								switch (_tmp331_) {
									case '=':
									{
										gchar* _tmp332_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_ADD;
										_tmp332_ = self->priv->current;
										self->priv->current = _tmp332_ + 1;
										break;
									}
									case '+':
									{
										gchar* _tmp333_;
										type = VALA_GENIE_TOKEN_TYPE_OP_INC;
										_tmp333_ = self->priv->current;
										self->priv->current = _tmp333_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '-':
						{
							gchar* _tmp334_;
							gchar* _tmp335_;
							gchar* _tmp336_;
							type = VALA_GENIE_TOKEN_TYPE_MINUS;
							_tmp334_ = self->priv->current;
							self->priv->current = _tmp334_ + 1;
							_tmp335_ = self->priv->current;
							_tmp336_ = self->priv->end;
							if (_tmp335_ < _tmp336_) {
								gchar* _tmp337_;
								gchar _tmp338_;
								_tmp337_ = self->priv->current;
								_tmp338_ = _tmp337_[0];
								switch (_tmp338_) {
									case '=':
									{
										gchar* _tmp339_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_SUB;
										_tmp339_ = self->priv->current;
										self->priv->current = _tmp339_ + 1;
										break;
									}
									case '-':
									{
										gchar* _tmp340_;
										type = VALA_GENIE_TOKEN_TYPE_OP_DEC;
										_tmp340_ = self->priv->current;
										self->priv->current = _tmp340_ + 1;
										break;
									}
									case '>':
									{
										gchar* _tmp341_;
										type = VALA_GENIE_TOKEN_TYPE_OP_PTR;
										_tmp341_ = self->priv->current;
										self->priv->current = _tmp341_ + 1;
										break;
									}
									default:
									break;
								}
							}
							break;
						}
						case '*':
						{
							gchar* _tmp342_;
							gboolean _tmp343_ = FALSE;
							gchar* _tmp344_;
							gchar* _tmp345_;
							type = VALA_GENIE_TOKEN_TYPE_STAR;
							_tmp342_ = self->priv->current;
							self->priv->current = _tmp342_ + 1;
							_tmp344_ = self->priv->current;
							_tmp345_ = self->priv->end;
							if (_tmp344_ < _tmp345_) {
								gchar* _tmp346_;
								gchar _tmp347_;
								_tmp346_ = self->priv->current;
								_tmp347_ = _tmp346_[0];
								_tmp343_ = _tmp347_ == '=';
							} else {
								_tmp343_ = FALSE;
							}
							if (_tmp343_) {
								gchar* _tmp348_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_MUL;
								_tmp348_ = self->priv->current;
								self->priv->current = _tmp348_ + 1;
							}
							break;
						}
						case '/':
						{
							ValaGenieTokenType _tmp349_;
							_tmp349_ = self->priv->last_token;
							switch (_tmp349_) {
								case VALA_GENIE_TOKEN_TYPE_ASSIGN:
								case VALA_GENIE_TOKEN_TYPE_COMMA:
								case VALA_GENIE_TOKEN_TYPE_MINUS:
								case VALA_GENIE_TOKEN_TYPE_OP_AND:
								case VALA_GENIE_TOKEN_TYPE_OP_EQ:
								case VALA_GENIE_TOKEN_TYPE_OP_GE:
								case VALA_GENIE_TOKEN_TYPE_OP_GT:
								case VALA_GENIE_TOKEN_TYPE_OP_INC:
								case VALA_GENIE_TOKEN_TYPE_OP_LE:
								case VALA_GENIE_TOKEN_TYPE_OP_LT:
								case VALA_GENIE_TOKEN_TYPE_OP_NE:
								case VALA_GENIE_TOKEN_TYPE_OP_NEG:
								case VALA_GENIE_TOKEN_TYPE_OP_OR:
								case VALA_GENIE_TOKEN_TYPE_OPEN_BRACE:
								case VALA_GENIE_TOKEN_TYPE_OPEN_PARENS:
								case VALA_GENIE_TOKEN_TYPE_PLUS:
								case VALA_GENIE_TOKEN_TYPE_RETURN:
								{
									ValaGenieScannerState* _tmp350_;
									gint _tmp350__length1;
									gchar* _tmp351_;
									type = VALA_GENIE_TOKEN_TYPE_OPEN_REGEX_LITERAL;
									_tmp350_ = self->priv->state_stack;
									_tmp350__length1 = self->priv->state_stack_length1;
									_vala_array_add10 (&self->priv->state_stack, &self->priv->state_stack_length1, &self->priv->_state_stack_size_, VALA_GENIE_SCANNER_STATE_REGEX_LITERAL);
									_tmp351_ = self->priv->current;
									self->priv->current = _tmp351_ + 1;
									break;
								}
								default:
								{
									gchar* _tmp352_;
									gboolean _tmp353_ = FALSE;
									gchar* _tmp354_;
									gchar* _tmp355_;
									type = VALA_GENIE_TOKEN_TYPE_DIV;
									_tmp352_ = self->priv->current;
									self->priv->current = _tmp352_ + 1;
									_tmp354_ = self->priv->current;
									_tmp355_ = self->priv->end;
									if (_tmp354_ < _tmp355_) {
										gchar* _tmp356_;
										gchar _tmp357_;
										_tmp356_ = self->priv->current;
										_tmp357_ = _tmp356_[0];
										_tmp353_ = _tmp357_ == '=';
									} else {
										_tmp353_ = FALSE;
									}
									if (_tmp353_) {
										gchar* _tmp358_;
										type = VALA_GENIE_TOKEN_TYPE_ASSIGN_DIV;
										_tmp358_ = self->priv->current;
										self->priv->current = _tmp358_ + 1;
									}
									break;
								}
							}
							break;
						}
						case '%':
						{
							gchar* _tmp359_;
							gboolean _tmp360_ = FALSE;
							gchar* _tmp361_;
							gchar* _tmp362_;
							type = VALA_GENIE_TOKEN_TYPE_PERCENT;
							_tmp359_ = self->priv->current;
							self->priv->current = _tmp359_ + 1;
							_tmp361_ = self->priv->current;
							_tmp362_ = self->priv->end;
							if (_tmp361_ < _tmp362_) {
								gchar* _tmp363_;
								gchar _tmp364_;
								_tmp363_ = self->priv->current;
								_tmp364_ = _tmp363_[0];
								_tmp360_ = _tmp364_ == '=';
							} else {
								_tmp360_ = FALSE;
							}
							if (_tmp360_) {
								gchar* _tmp365_;
								type = VALA_GENIE_TOKEN_TYPE_ASSIGN_PERCENT;
								_tmp365_ = self->priv->current;
								self->priv->current = _tmp365_ + 1;
							}
							break;
						}
						case '\'':
						case '"':
						{
							gchar* _tmp366_;
							gchar _tmp367_;
							gchar* _tmp416_;
							gchar* _tmp472_;
							gchar* _tmp473_;
							_tmp366_ = begin;
							_tmp367_ = _tmp366_[0];
							if (_tmp367_ == '\'') {
								type = VALA_GENIE_TOKEN_TYPE_CHARACTER_LITERAL;
							} else {
								gboolean _tmp368_ = FALSE;
								gboolean _tmp369_ = FALSE;
								gchar* _tmp370_;
								gchar* _tmp371_;
								_tmp370_ = self->priv->current;
								_tmp371_ = self->priv->end;
								if (_tmp370_ < (_tmp371_ - 6)) {
									gchar* _tmp372_;
									gchar _tmp373_;
									_tmp372_ = begin;
									_tmp373_ = _tmp372_[1];
									_tmp369_ = _tmp373_ == '"';
								} else {
									_tmp369_ = FALSE;
								}
								if (_tmp369_) {
									gchar* _tmp374_;
									gchar _tmp375_;
									_tmp374_ = begin;
									_tmp375_ = _tmp374_[2];
									_tmp368_ = _tmp375_ == '"';
								} else {
									_tmp368_ = FALSE;
								}
								if (_tmp368_) {
									gchar* _tmp376_;
									gboolean _tmp404_ = FALSE;
									gboolean _tmp405_ = FALSE;
									gchar* _tmp406_;
									gchar _tmp407_;
									type = VALA_GENIE_TOKEN_TYPE_VERBATIM_STRING_LITERAL;
									token_length_in_chars = 6;
									_tmp376_ = self->priv->current;
									self->priv->current = _tmp376_ + 3;
									while (TRUE) {
										gchar* _tmp377_;
										gchar* _tmp378_;
										gboolean _tmp379_ = FALSE;
										gboolean _tmp380_ = FALSE;
										gboolean _tmp381_ = FALSE;
										gchar* _tmp382_;
										gchar _tmp383_;
										_tmp377_ = self->priv->current;
										_tmp378_ = self->priv->end;
										if (!(_tmp377_ < (_tmp378_ - 4))) {
											break;
										}
										_tmp382_ = self->priv->current;
										_tmp383_ = _tmp382_[0];
										if (_tmp383_ == '"') {
											gchar* _tmp384_;
											gchar _tmp385_;
											_tmp384_ = self->priv->current;
											_tmp385_ = _tmp384_[1];
											_tmp381_ = _tmp385_ == '"';
										} else {
											_tmp381_ = FALSE;
										}
										if (_tmp381_) {
											gchar* _tmp386_;
											gchar _tmp387_;
											_tmp386_ = self->priv->current;
											_tmp387_ = _tmp386_[2];
											_tmp380_ = _tmp387_ == '"';
										} else {
											_tmp380_ = FALSE;
										}
										if (_tmp380_) {
											gchar* _tmp388_;
											gchar _tmp389_;
											_tmp388_ = self->priv->current;
											_tmp389_ = _tmp388_[3];
											_tmp379_ = _tmp389_ != '"';
										} else {
											_tmp379_ = FALSE;
										}
										if (_tmp379_) {
											break;
										} else {
											gchar* _tmp390_;
											gchar _tmp391_;
											_tmp390_ = self->priv->current;
											_tmp391_ = _tmp390_[0];
											if (_tmp391_ == '\n') {
												gchar* _tmp392_;
												gint _tmp393_;
												_tmp392_ = self->priv->current;
												self->priv->current = _tmp392_ + 1;
												_tmp393_ = self->priv->line;
												self->priv->line = _tmp393_ + 1;
												self->priv->column = 1;
												token_length_in_chars = 3;
											} else {
												gunichar u = 0U;
												gchar* _tmp394_;
												gchar* _tmp395_;
												gchar* _tmp396_;
												gunichar _tmp397_;
												_tmp394_ = self->priv->current;
												_tmp395_ = self->priv->end;
												_tmp396_ = self->priv->current;
												u = g_utf8_get_char_validated ((const gchar*) _tmp394_, (gssize) ((glong) (_tmp395_ - _tmp396_)));
												_tmp397_ = u;
												if (_tmp397_ != ((gunichar) -1)) {
													gchar* _tmp398_;
													gunichar _tmp399_;
													gint _tmp400_;
													_tmp398_ = self->priv->current;
													_tmp399_ = u;
													self->priv->current = _tmp398_ + g_unichar_to_utf8 (_tmp399_, NULL);
													_tmp400_ = token_length_in_chars;
													token_length_in_chars = _tmp400_ + 1;
												} else {
													gint _tmp401_;
													ValaSourceReference* _tmp402_;
													ValaSourceReference* _tmp403_;
													_tmp401_ = token_length_in_chars;
													_tmp402_ = vala_genie_scanner_get_source_reference (self, _tmp401_, 0);
													_tmp403_ = _tmp402_;
													vala_report_error (_tmp403_, "invalid UTF-8 character");
													_vala_source_reference_unref0 (_tmp403_);
												}
											}
										}
									}
									_tmp406_ = self->priv->current;
									_tmp407_ = _tmp406_[0];
									if (_tmp407_ == '"') {
										gchar* _tmp408_;
										gchar _tmp409_;
										_tmp408_ = self->priv->current;
										_tmp409_ = _tmp408_[1];
										_tmp405_ = _tmp409_ == '"';
									} else {
										_tmp405_ = FALSE;
									}
									if (_tmp405_) {
										gchar* _tmp410_;
										gchar _tmp411_;
										_tmp410_ = self->priv->current;
										_tmp411_ = _tmp410_[2];
										_tmp404_ = _tmp411_ == '"';
									} else {
										_tmp404_ = FALSE;
									}
									if (_tmp404_) {
										gchar* _tmp412_;
										_tmp412_ = self->priv->current;
										self->priv->current = _tmp412_ + 3;
									} else {
										gint _tmp413_;
										ValaSourceReference* _tmp414_;
										ValaSourceReference* _tmp415_;
										_tmp413_ = token_length_in_chars;
										_tmp414_ = vala_genie_scanner_get_source_reference (self, _tmp413_, 0);
										_tmp415_ = _tmp414_;
										vala_report_error (_tmp415_, "syntax error, expected \"\"\"");
										_vala_source_reference_unref0 (_tmp415_);
									}
									break;
								} else {
									type = VALA_GENIE_TOKEN_TYPE_STRING_LITERAL;
								}
							}
							token_length_in_chars = 2;
							_tmp416_ = self->priv->current;
							self->priv->current = _tmp416_ + 1;
							while (TRUE) {
								gboolean _tmp417_ = FALSE;
								gchar* _tmp418_;
								gchar* _tmp419_;
								gchar* _tmp424_;
								gchar _tmp425_;
								gboolean _tmp461_ = FALSE;
								gboolean _tmp462_ = FALSE;
								gchar* _tmp463_;
								gchar* _tmp464_;
								_tmp418_ = self->priv->current;
								_tmp419_ = self->priv->end;
								if (_tmp418_ < _tmp419_) {
									gchar* _tmp420_;
									gchar _tmp421_;
									gchar* _tmp422_;
									gchar _tmp423_;
									_tmp420_ = self->priv->current;
									_tmp421_ = _tmp420_[0];
									_tmp422_ = begin;
									_tmp423_ = _tmp422_[0];
									_tmp417_ = _tmp421_ != _tmp423_;
								} else {
									_tmp417_ = FALSE;
								}
								if (!_tmp417_) {
									break;
								}
								_tmp424_ = self->priv->current;
								_tmp425_ = _tmp424_[0];
								if (_tmp425_ == '\\') {
									gchar* _tmp426_;
									gint _tmp427_;
									gchar* _tmp428_;
									gchar* _tmp429_;
									gchar* _tmp430_;
									gchar _tmp431_;
									_tmp426_ = self->priv->current;
									self->priv->current = _tmp426_ + 1;
									_tmp427_ = token_length_in_chars;
									token_length_in_chars = _tmp427_ + 1;
									_tmp428_ = self->priv->current;
									_tmp429_ = self->priv->end;
									if (_tmp428_ >= _tmp429_) {
										break;
									}
									_tmp430_ = self->priv->current;
									_tmp431_ = _tmp430_[0];
									switch (_tmp431_) {
										case '\'':
										case '"':
										case '\\':
										case '0':
										case 'b':
										case 'f':
										case 'n':
										case 'r':
										case 't':
										{
											gchar* _tmp432_;
											gint _tmp433_;
											_tmp432_ = self->priv->current;
											self->priv->current = _tmp432_ + 1;
											_tmp433_ = token_length_in_chars;
											token_length_in_chars = _tmp433_ + 1;
											break;
										}
										case 'x':
										{
											gchar* _tmp434_;
											gint _tmp435_;
											_tmp434_ = self->priv->current;
											self->priv->current = _tmp434_ + 1;
											_tmp435_ = token_length_in_chars;
											token_length_in_chars = _tmp435_ + 1;
											while (TRUE) {
												gboolean _tmp436_ = FALSE;
												gchar* _tmp437_;
												gchar* _tmp438_;
												gchar* _tmp441_;
												gint _tmp442_;
												_tmp437_ = self->priv->current;
												_tmp438_ = self->priv->end;
												if (_tmp437_ < _tmp438_) {
													gchar* _tmp439_;
													gchar _tmp440_;
													_tmp439_ = self->priv->current;
													_tmp440_ = _tmp439_[0];
													_tmp436_ = g_ascii_isxdigit (_tmp440_);
												} else {
													_tmp436_ = FALSE;
												}
												if (!_tmp436_) {
													break;
												}
												_tmp441_ = self->priv->current;
												self->priv->current = _tmp441_ + 1;
												_tmp442_ = token_length_in_chars;
												token_length_in_chars = _tmp442_ + 1;
											}
											break;
										}
										default:
										{
											gint _tmp443_;
											ValaSourceReference* _tmp444_;
											ValaSourceReference* _tmp445_;
											_tmp443_ = token_length_in_chars;
											_tmp444_ = vala_genie_scanner_get_source_reference (self, _tmp443_, 0);
											_tmp445_ = _tmp444_;
											vala_report_error (_tmp445_, "invalid escape sequence");
											_vala_source_reference_unref0 (_tmp445_);
											break;
										}
									}
								} else {
									gchar* _tmp446_;
									gchar _tmp447_;
									_tmp446_ = self->priv->current;
									_tmp447_ = _tmp446_[0];
									if (_tmp447_ == '\n') {
										gchar* _tmp448_;
										gint _tmp449_;
										_tmp448_ = self->priv->current;
										self->priv->current = _tmp448_ + 1;
										_tmp449_ = self->priv->line;
										self->priv->line = _tmp449_ + 1;
										self->priv->column = 1;
										token_length_in_chars = 1;
									} else {
										gunichar u = 0U;
										gchar* _tmp450_;
										gchar* _tmp451_;
										gchar* _tmp452_;
										gunichar _tmp453_;
										_tmp450_ = self->priv->current;
										_tmp451_ = self->priv->end;
										_tmp452_ = self->priv->current;
										u = g_utf8_get_char_validated ((const gchar*) _tmp450_, (gssize) ((glong) (_tmp451_ - _tmp452_)));
										_tmp453_ = u;
										if (_tmp453_ != ((gunichar) -1)) {
											gchar* _tmp454_;
											gunichar _tmp455_;
											gint _tmp456_;
											_tmp454_ = self->priv->current;
											_tmp455_ = u;
											self->priv->current = _tmp454_ + g_unichar_to_utf8 (_tmp455_, NULL);
											_tmp456_ = token_length_in_chars;
											token_length_in_chars = _tmp456_ + 1;
										} else {
											gchar* _tmp457_;
											gint _tmp458_;
											ValaSourceReference* _tmp459_;
											ValaSourceReference* _tmp460_;
											_tmp457_ = self->priv->current;
											self->priv->current = _tmp457_ + 1;
											_tmp458_ = token_length_in_chars;
											_tmp459_ = vala_genie_scanner_get_source_reference (self, _tmp458_, 0);
											_tmp460_ = _tmp459_;
											vala_report_error (_tmp460_, "invalid UTF-8 character");
											_vala_source_reference_unref0 (_tmp460_);
										}
									}
								}
								_tmp463_ = self->priv->current;
								_tmp464_ = self->priv->end;
								if (_tmp463_ < _tmp464_) {
									gchar* _tmp465_;
									gchar _tmp466_;
									_tmp465_ = begin;
									_tmp466_ = _tmp465_[0];
									_tmp462_ = _tmp466_ == '\'';
								} else {
									_tmp462_ = FALSE;
								}
								if (_tmp462_) {
									gchar* _tmp467_;
									gchar _tmp468_;
									_tmp467_ = self->priv->current;
									_tmp468_ = _tmp467_[0];
									_tmp461_ = _tmp468_ != '\'';
								} else {
									_tmp461_ = FALSE;
								}
								if (_tmp461_) {
									gint _tmp469_;
									ValaSourceReference* _tmp470_;
									ValaSourceReference* _tmp471_;
									_tmp469_ = token_length_in_chars;
									_tmp470_ = vala_genie_scanner_get_source_reference (self, _tmp469_, 0);
									_tmp471_ = _tmp470_;
									vala_report_error (_tmp471_, "invalid character literal");
									_vala_source_reference_unref0 (_tmp471_);
								}
							}
							_tmp472_ = self->priv->current;
							_tmp473_ = self->priv->end;
							if (_tmp472_ < _tmp473_) {
								gchar* _tmp474_;
								_tmp474_ = self->priv->current;
								self->priv->current = _tmp474_ + 1;
							} else {
								gint _tmp475_;
								ValaSourceReference* _tmp476_;
								ValaSourceReference* _tmp477_;
								gchar* _tmp478_;
								gchar _tmp479_;
								gchar* _tmp480_;
								gchar* _tmp481_;
								_tmp475_ = token_length_in_chars;
								_tmp476_ = vala_genie_scanner_get_source_reference (self, _tmp475_, 0);
								_tmp477_ = _tmp476_;
								_tmp478_ = begin;
								_tmp479_ = _tmp478_[0];
								_tmp480_ = g_strdup_printf ("syntax error, expected %c", (gint) _tmp479_);
								_tmp481_ = _tmp480_;
								vala_report_error (_tmp477_, _tmp481_);
								_g_free0 (_tmp481_);
								_vala_source_reference_unref0 (_tmp477_);
							}
							break;
						}
						default:
						{
							gunichar u = 0U;
							gchar* _tmp482_;
							gchar* _tmp483_;
							gchar* _tmp484_;
							gunichar _tmp485_;
							gint _tmp493_;
							ValaSourceLocation _tmp494_ = {0};
							ValaSourceLocation _tmp495_ = {0};
							ValaGenieTokenType _tmp496_;
							_tmp482_ = self->priv->current;
							_tmp483_ = self->priv->end;
							_tmp484_ = self->priv->current;
							u = g_utf8_get_char_validated ((const gchar*) _tmp482_, (gssize) ((glong) (_tmp483_ - _tmp484_)));
							_tmp485_ = u;
							if (_tmp485_ != ((gunichar) -1)) {
								gchar* _tmp486_;
								gunichar _tmp487_;
								ValaSourceReference* _tmp488_;
								ValaSourceReference* _tmp489_;
								_tmp486_ = self->priv->current;
								_tmp487_ = u;
								self->priv->current = _tmp486_ + g_unichar_to_utf8 (_tmp487_, NULL);
								_tmp488_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp489_ = _tmp488_;
								vala_report_error (_tmp489_, "syntax error, unexpected character");
								_vala_source_reference_unref0 (_tmp489_);
							} else {
								gchar* _tmp490_;
								ValaSourceReference* _tmp491_;
								ValaSourceReference* _tmp492_;
								_tmp490_ = self->priv->current;
								self->priv->current = _tmp490_ + 1;
								_tmp491_ = vala_genie_scanner_get_source_reference (self, 0, 0);
								_tmp492_ = _tmp491_;
								vala_report_error (_tmp492_, "invalid UTF-8 character");
								_vala_source_reference_unref0 (_tmp492_);
							}
							_tmp493_ = self->priv->column;
							self->priv->column = _tmp493_ + 1;
							_tmp496_ = vala_genie_scanner_read_token (self, &_tmp494_, &_tmp495_);
							_vala_token_begin = _tmp494_;
							_vala_token_end = _tmp495_;
							result = _tmp496_;
							if (token_begin) {
								*token_begin = _vala_token_begin;
							}
							if (token_end) {
								*token_end = _vala_token_end;
							}
							return result;
						}
					}
				}
			}
		}
	}
	_tmp497_ = token_length_in_chars;
	if (_tmp497_ < 0) {
		gint _tmp498_;
		gchar* _tmp499_;
		gchar* _tmp500_;
		_tmp498_ = self->priv->column;
		_tmp499_ = self->priv->current;
		_tmp500_ = begin;
		self->priv->column = _tmp498_ + ((gint) (_tmp499_ - _tmp500_));
	} else {
		gint _tmp501_;
		gint _tmp502_;
		_tmp501_ = self->priv->column;
		_tmp502_ = token_length_in_chars;
		self->priv->column = _tmp501_ + _tmp502_;
	}
	_tmp503_ = self->priv->current;
	_tmp504_ = self->priv->line;
	_tmp505_ = self->priv->column;
	vala_source_location_init (&_vala_token_end, _tmp503_, _tmp504_, _tmp505_ - 1);
	_tmp506_ = type;
	self->priv->last_token = _tmp506_;
	result = type;
	if (token_begin) {
		*token_begin = _vala_token_begin;
	}
	if (token_end) {
		*token_end = _vala_token_end;
	}
	return result;
}


static gint
vala_genie_scanner_count_tabs (ValaGenieScanner* self)
{
	gint result = 0;
	gint tab_count = 0;
	gint _tmp0_;
	gboolean _tmp19_ = FALSE;
	gchar* _tmp20_;
	gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, 0);
	tab_count = 0;
	_tmp0_ = self->priv->_indent_spaces;
	if (_tmp0_ == 0) {
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			_tmp2_ = self->priv->current;
			_tmp3_ = self->priv->end;
			if (_tmp2_ < _tmp3_) {
				gchar* _tmp4_;
				gchar _tmp5_;
				_tmp4_ = self->priv->current;
				_tmp5_ = _tmp4_[0];
				_tmp1_ = _tmp5_ == '\t';
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp6_ = self->priv->current;
			self->priv->current = _tmp6_ + 1;
			_tmp7_ = self->priv->column;
			self->priv->column = _tmp7_ + 1;
			_tmp8_ = tab_count;
			tab_count = _tmp8_ + 1;
		}
	} else {
		gint space_count = 0;
		gint _tmp17_;
		gint _tmp18_;
		space_count = 0;
		while (TRUE) {
			gboolean _tmp9_ = FALSE;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			_tmp10_ = self->priv->current;
			_tmp11_ = self->priv->end;
			if (_tmp10_ < _tmp11_) {
				gchar* _tmp12_;
				gchar _tmp13_;
				_tmp12_ = self->priv->current;
				_tmp13_ = _tmp12_[0];
				_tmp9_ = _tmp13_ == ' ';
			} else {
				_tmp9_ = FALSE;
			}
			if (!_tmp9_) {
				break;
			}
			_tmp14_ = self->priv->current;
			self->priv->current = _tmp14_ + 1;
			_tmp15_ = self->priv->column;
			self->priv->column = _tmp15_ + 1;
			_tmp16_ = space_count;
			space_count = _tmp16_ + 1;
		}
		_tmp17_ = space_count;
		_tmp18_ = self->priv->_indent_spaces;
		tab_count = _tmp17_ / _tmp18_;
	}
	vala_genie_scanner_space (self);
	_tmp20_ = self->priv->current;
	_tmp21_ = self->priv->end;
	if (_tmp20_ < _tmp21_) {
		gchar* _tmp22_;
		gchar _tmp23_;
		_tmp22_ = self->priv->current;
		_tmp23_ = _tmp22_[0];
		_tmp19_ = _tmp23_ == '\n';
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		result = -1;
		return result;
	}
	result = tab_count;
	return result;
}


static gboolean
vala_genie_scanner_matches (gchar* begin,
                            const gchar* keyword)
{
	gboolean result = FALSE;
	gchar* keyword_array = NULL;
	glong len = 0L;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (keyword != NULL, FALSE);
	keyword_array = (gchar*) keyword;
	_tmp0_ = strlen (keyword);
	_tmp1_ = _tmp0_;
	len = (glong) _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				glong _tmp5_;
				gint _tmp6_;
				gchar _tmp7_;
				gchar* _tmp8_;
				gint _tmp9_;
				gchar _tmp10_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = len;
				if (!(((glong) _tmp4_) < _tmp5_)) {
					break;
				}
				_tmp6_ = i;
				_tmp7_ = begin[_tmp6_];
				_tmp8_ = keyword_array;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				if (_tmp7_ != _tmp10_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean
vala_genie_scanner_whitespace (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	_tmp12_ = self->priv->column;
	if (_tmp12_ == 1) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->end;
		_tmp11_ = _tmp13_ < _tmp14_;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gchar* _tmp15_;
		gchar _tmp16_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_[0];
		_tmp10_ = _tmp16_ == '#';
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		vala_genie_scanner_pp_directive (self);
		result = TRUE;
		return result;
	}
	result = found;
	return result;
}


static inline gboolean
vala_genie_scanner_newline (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = _tmp0_[0];
	if (_tmp1_ == '\n') {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_genie_scanner_skip_newlines (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean new_lines = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	new_lines = FALSE;
	while (TRUE) {
		gchar* _tmp0_;
		gint _tmp1_;
		if (!vala_genie_scanner_newline (self)) {
			break;
		}
		_tmp0_ = self->priv->current;
		self->priv->current = _tmp0_ + 1;
		_tmp1_ = self->priv->line;
		self->priv->line = _tmp1_ + 1;
		self->priv->column = 1;
		self->priv->current_indent_level = 0;
		new_lines = TRUE;
	}
	result = new_lines;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gboolean
vala_genie_scanner_comment (ValaGenieScanner* self,
                            gboolean file_comment)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar* _tmp3_;
	gchar* _tmp13_;
	gchar _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp3_ = self->priv->current;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		_tmp2_ = _tmp4_ > (_tmp5_ - 2);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gchar* _tmp6_;
		gchar _tmp7_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_[0];
		_tmp1_ = _tmp7_ != '/';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		gchar* _tmp9_;
		gchar _tmp10_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_[1];
		if (_tmp10_ != '/') {
			gchar* _tmp11_;
			gchar _tmp12_;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_[1];
			_tmp8_ = _tmp12_ != '*';
		} else {
			_tmp8_ = FALSE;
		}
		_tmp0_ = _tmp8_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_[1];
	if (_tmp14_ == '/') {
		ValaSourceReference* source_reference = NULL;
		gchar* _tmp16_;
		gboolean _tmp23_ = FALSE;
		gchar* _tmp24_;
		gchar _tmp25_;
		ValaSourceReference* _tmp29_;
		source_reference = NULL;
		if (file_comment) {
			ValaSourceReference* _tmp15_;
			_tmp15_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp15_;
		}
		_tmp16_ = self->priv->current;
		self->priv->current = _tmp16_ + 2;
		while (TRUE) {
			gboolean _tmp17_ = FALSE;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp22_;
			_tmp18_ = self->priv->current;
			_tmp19_ = self->priv->end;
			if (_tmp18_ < _tmp19_) {
				gchar* _tmp20_;
				gchar _tmp21_;
				_tmp20_ = self->priv->current;
				_tmp21_ = _tmp20_[0];
				_tmp17_ = _tmp21_ != '\n';
			} else {
				_tmp17_ = FALSE;
			}
			if (!_tmp17_) {
				break;
			}
			_tmp22_ = self->priv->current;
			self->priv->current = _tmp22_ + 1;
		}
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_[0];
		if (_tmp25_ == '\n') {
			ValaGenieTokenType _tmp26_;
			_tmp26_ = self->priv->last_token;
			_tmp23_ = _tmp26_ == VALA_GENIE_TOKEN_TYPE_EOL;
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			gchar* _tmp27_;
			gint _tmp28_;
			_tmp27_ = self->priv->current;
			self->priv->current = _tmp27_ + 1;
			_tmp28_ = self->priv->line;
			self->priv->line = _tmp28_ + 1;
			self->priv->column = 1;
			self->priv->current_indent_level = 0;
		}
		_tmp29_ = source_reference;
		if (_tmp29_ != NULL) {
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			_tmp30_ = self->priv->begin;
			_tmp31_ = self->priv->current;
			_tmp32_ = self->priv->begin;
			_tmp33_ = string_substring ((const gchar*) _tmp30_, (glong) 0, (glong) (_tmp31_ - _tmp32_));
			_tmp34_ = _tmp33_;
			_tmp35_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp34_, _tmp35_, file_comment);
			_g_free0 (_tmp34_);
		}
		_vala_source_reference_unref0 (source_reference);
	} else {
		ValaSourceReference* source_reference = NULL;
		gboolean _tmp36_ = FALSE;
		gboolean _tmp39_ = FALSE;
		gchar* _tmp40_;
		gchar _tmp41_;
		gchar* _tmp43_;
		gchar* begin = NULL;
		gchar* _tmp44_;
		gchar* _tmp58_;
		gchar* _tmp59_;
		ValaSourceReference* _tmp62_;
		gchar* _tmp69_;
		gint _tmp70_;
		source_reference = NULL;
		if (file_comment) {
			gchar* _tmp37_;
			gchar _tmp38_;
			_tmp37_ = self->priv->current;
			_tmp38_ = _tmp37_[2];
			_tmp36_ = _tmp38_ == '*';
		} else {
			_tmp36_ = FALSE;
		}
		if (_tmp36_) {
			result = FALSE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp40_ = self->priv->current;
		_tmp41_ = _tmp40_[2];
		if (_tmp41_ == '*') {
			_tmp39_ = TRUE;
		} else {
			_tmp39_ = file_comment;
		}
		if (_tmp39_) {
			ValaSourceReference* _tmp42_;
			_tmp42_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_vala_source_reference_unref0 (source_reference);
			source_reference = _tmp42_;
		}
		_tmp43_ = self->priv->current;
		self->priv->current = _tmp43_ + 2;
		_tmp44_ = self->priv->current;
		begin = _tmp44_;
		while (TRUE) {
			gboolean _tmp45_ = FALSE;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp53_;
			gchar _tmp54_;
			gchar* _tmp56_;
			gint _tmp57_;
			_tmp46_ = self->priv->current;
			_tmp47_ = self->priv->end;
			if (_tmp46_ < (_tmp47_ - 1)) {
				gboolean _tmp48_ = FALSE;
				gchar* _tmp49_;
				gchar _tmp50_;
				_tmp49_ = self->priv->current;
				_tmp50_ = _tmp49_[0];
				if (_tmp50_ != '*') {
					_tmp48_ = TRUE;
				} else {
					gchar* _tmp51_;
					gchar _tmp52_;
					_tmp51_ = self->priv->current;
					_tmp52_ = _tmp51_[1];
					_tmp48_ = _tmp52_ != '/';
				}
				_tmp45_ = _tmp48_;
			} else {
				_tmp45_ = FALSE;
			}
			if (!_tmp45_) {
				break;
			}
			_tmp53_ = self->priv->current;
			_tmp54_ = _tmp53_[0];
			if (_tmp54_ == '\n') {
				gint _tmp55_;
				_tmp55_ = self->priv->line;
				self->priv->line = _tmp55_ + 1;
				self->priv->column = 0;
			}
			_tmp56_ = self->priv->current;
			self->priv->current = _tmp56_ + 1;
			_tmp57_ = self->priv->column;
			self->priv->column = _tmp57_ + 1;
		}
		_tmp58_ = self->priv->current;
		_tmp59_ = self->priv->end;
		if (_tmp58_ == (_tmp59_ - 1)) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			_tmp60_ = vala_genie_scanner_get_source_reference (self, 0, 0);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp61_, "syntax error, expected */");
			_vala_source_reference_unref0 (_tmp61_);
			result = TRUE;
			_vala_source_reference_unref0 (source_reference);
			return result;
		}
		_tmp62_ = source_reference;
		if (_tmp62_ != NULL) {
			gchar* comment = NULL;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			const gchar* _tmp67_;
			ValaSourceReference* _tmp68_;
			_tmp63_ = begin;
			_tmp64_ = self->priv->current;
			_tmp65_ = begin;
			_tmp66_ = string_substring ((const gchar*) _tmp63_, (glong) 0, (glong) (_tmp64_ - _tmp65_));
			comment = _tmp66_;
			_tmp67_ = comment;
			_tmp68_ = source_reference;
			vala_genie_scanner_push_comment (self, _tmp67_, _tmp68_, file_comment);
			_g_free0 (comment);
		}
		_tmp69_ = self->priv->current;
		self->priv->current = _tmp69_ + 2;
		_tmp70_ = self->priv->column;
		self->priv->column = _tmp70_ + 2;
		_vala_source_reference_unref0 (source_reference);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_genie_scanner_skip_tabs (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = _tmp4_ == '\t';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		found = TRUE;
	}
	result = found;
	return result;
}


static void
vala_genie_scanner_skip_space_tabs (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = vala_genie_scanner_skip_tabs (self);
		}
		if (_tmp1_) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void
vala_genie_scanner_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


void
vala_genie_scanner_parse_file_comments (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, TRUE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static void
vala_genie_scanner_push_comment (ValaGenieScanner* self,
                                 const gchar* comment_item,
                                 ValaSourceReference* source_reference,
                                 gboolean file_comment)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (comment_item != NULL);
	g_return_if_fail (source_reference != NULL);
	if (string_get (comment_item, (glong) 0) == '*') {
		ValaComment* _tmp0_;
		ValaComment* _tmp3_;
		_tmp0_ = self->priv->_comment;
		if (_tmp0_ != NULL) {
			ValaSourceFile* _tmp1_;
			ValaComment* _tmp2_;
			_tmp1_ = self->priv->_source_file;
			_tmp2_ = self->priv->_comment;
			vala_source_file_add_comment (_tmp1_, _tmp2_);
		}
		_tmp3_ = vala_comment_new (comment_item, source_reference);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = _tmp3_;
	}
	if (file_comment) {
		ValaSourceFile* _tmp4_;
		ValaComment* _tmp5_;
		ValaComment* _tmp6_;
		_tmp4_ = self->priv->_source_file;
		_tmp5_ = vala_comment_new (comment_item, source_reference);
		_tmp6_ = _tmp5_;
		vala_source_file_add_comment (_tmp4_, _tmp6_);
		_vala_comment_unref0 (_tmp6_);
		_vala_comment_unref0 (self->priv->_comment);
		self->priv->_comment = NULL;
	}
}


/**
 * Clears and returns the content of the comment stack.
 *
 * @return saved comment
 */
static gpointer
_vala_comment_ref0 (gpointer self)
{
	return self ? vala_comment_ref (self) : NULL;
}


ValaComment*
vala_genie_scanner_pop_comment (ValaGenieScanner* self)
{
	ValaComment* result = NULL;
	ValaComment* _tmp0_;
	ValaComment* comment = NULL;
	ValaComment* _tmp1_;
	ValaComment* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_comment;
	if (_tmp0_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = self->priv->_comment;
	_tmp2_ = _vala_comment_ref0 (_tmp1_);
	comment = _tmp2_;
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->_comment = NULL;
	result = comment;
	return result;
}


static gboolean
vala_genie_scanner_pp_whitespace (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean found = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	found = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < _tmp3_) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = g_ascii_isspace (_tmp5_);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp0_ = _tmp7_ != '\n';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		found = TRUE;
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
	}
	result = found;
	return result;
}


static void
vala_genie_scanner_pp_space (ValaGenieScanner* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (vala_genie_scanner_pp_whitespace (self)) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = vala_genie_scanner_comment (self, FALSE);
		}
		if (!_tmp0_) {
			break;
		}
	}
}


static void
vala_genie_scanner_pp_directive (ValaGenieScanner* self)
{
	gchar* _tmp0_;
	gint _tmp1_;
	gchar* begin = NULL;
	gchar* _tmp2_;
	gint len = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_;
	gboolean _tmp27_ = FALSE;
	ValaGenieScannerConditional* _tmp28_;
	gint _tmp28__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	self->priv->current = _tmp0_ + 1;
	_tmp1_ = self->priv->column;
	self->priv->column = _tmp1_ + 1;
	vala_genie_scanner_pp_space (self);
	_tmp2_ = self->priv->current;
	begin = _tmp2_;
	len = 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp4_ = self->priv->current;
		_tmp5_ = self->priv->end;
		if (_tmp4_ < _tmp5_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			_tmp3_ = g_ascii_isalnum (_tmp7_);
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 1;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 1;
		_tmp10_ = len;
		len = _tmp10_ + 1;
	}
	_tmp12_ = len;
	if (_tmp12_ == 2) {
		gchar* _tmp13_;
		_tmp13_ = begin;
		_tmp11_ = vala_genie_scanner_matches (_tmp13_, "if");
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		vala_genie_scanner_parse_pp_if (self);
	} else {
		gboolean _tmp14_ = FALSE;
		gint _tmp15_;
		_tmp15_ = len;
		if (_tmp15_ == 4) {
			gchar* _tmp16_;
			_tmp16_ = begin;
			_tmp14_ = vala_genie_scanner_matches (_tmp16_, "elif");
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			vala_genie_scanner_parse_pp_elif (self);
		} else {
			gboolean _tmp17_ = FALSE;
			gint _tmp18_;
			_tmp18_ = len;
			if (_tmp18_ == 4) {
				gchar* _tmp19_;
				_tmp19_ = begin;
				_tmp17_ = vala_genie_scanner_matches (_tmp19_, "else");
			} else {
				_tmp17_ = FALSE;
			}
			if (_tmp17_) {
				vala_genie_scanner_parse_pp_else (self);
			} else {
				gboolean _tmp20_ = FALSE;
				gint _tmp21_;
				_tmp21_ = len;
				if (_tmp21_ == 5) {
					gchar* _tmp22_;
					_tmp22_ = begin;
					_tmp20_ = vala_genie_scanner_matches (_tmp22_, "endif");
				} else {
					_tmp20_ = FALSE;
				}
				if (_tmp20_) {
					vala_genie_scanner_parse_pp_endif (self);
				} else {
					gint _tmp23_;
					gint _tmp24_;
					ValaSourceReference* _tmp25_;
					ValaSourceReference* _tmp26_;
					_tmp23_ = len;
					_tmp24_ = len;
					_tmp25_ = vala_genie_scanner_get_source_reference (self, -_tmp23_, _tmp24_);
					_tmp26_ = _tmp25_;
					vala_report_error (_tmp26_, "syntax error, invalid preprocessing directive");
					_vala_source_reference_unref0 (_tmp26_);
				}
			}
		}
	}
	_tmp28_ = self->priv->conditional_stack;
	_tmp28__length1 = self->priv->conditional_stack_length1;
	if (_tmp28__length1 > 0) {
		ValaGenieScannerConditional* _tmp29_;
		gint _tmp29__length1;
		ValaGenieScannerConditional* _tmp30_;
		gint _tmp30__length1;
		ValaGenieScannerConditional _tmp31_;
		gboolean _tmp32_;
		_tmp29_ = self->priv->conditional_stack;
		_tmp29__length1 = self->priv->conditional_stack_length1;
		_tmp30_ = self->priv->conditional_stack;
		_tmp30__length1 = self->priv->conditional_stack_length1;
		_tmp31_ = _tmp29_[_tmp30__length1 - 1];
		_tmp32_ = _tmp31_.skip_section;
		_tmp27_ = _tmp32_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		gboolean bol = FALSE;
		bol = FALSE;
		while (TRUE) {
			gchar* _tmp33_;
			gchar* _tmp34_;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
			gboolean _tmp37_;
			gchar* _tmp44_;
			gchar _tmp45_;
			gchar* _tmp49_;
			gint _tmp50_;
			_tmp33_ = self->priv->current;
			_tmp34_ = self->priv->end;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp37_ = bol;
			if (_tmp37_) {
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp38_ = self->priv->current;
				_tmp39_ = self->priv->end;
				_tmp36_ = _tmp38_ < _tmp39_;
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				gchar* _tmp40_;
				gchar _tmp41_;
				_tmp40_ = self->priv->current;
				_tmp41_ = _tmp40_[0];
				_tmp35_ = _tmp41_ == '#';
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				gchar* _tmp42_;
				gint _tmp43_;
				_tmp42_ = self->priv->current;
				_tmp43_ = self->priv->column;
				self->priv->current = _tmp42_ - (_tmp43_ - 1);
				self->priv->column = 1;
				return;
			}
			_tmp44_ = self->priv->current;
			_tmp45_ = _tmp44_[0];
			if (_tmp45_ == '\n') {
				gint _tmp46_;
				_tmp46_ = self->priv->line;
				self->priv->line = _tmp46_ + 1;
				self->priv->column = 0;
				bol = TRUE;
			} else {
				gchar* _tmp47_;
				gchar _tmp48_;
				_tmp47_ = self->priv->current;
				_tmp48_ = _tmp47_[0];
				if (!g_ascii_isspace (_tmp48_)) {
					bol = FALSE;
				}
			}
			_tmp49_ = self->priv->current;
			self->priv->current = _tmp49_ + 1;
			_tmp50_ = self->priv->column;
			self->priv->column = _tmp50_ + 1;
		}
	}
}


static void
vala_genie_scanner_pp_eol (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ >= _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ != '\n';
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		_tmp5_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp6_ = _tmp5_;
		vala_report_error (_tmp6_, "syntax error, expected newline");
		_vala_source_reference_unref0 (_tmp6_);
	}
}


static void
_vala_array_add11 (ValaGenieScannerConditional* * array,
                   int* length,
                   int* size,
                   const ValaGenieScannerConditional* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (ValaGenieScannerConditional, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void
vala_genie_scanner_parse_pp_if (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	ValaGenieScannerConditional* _tmp0_;
	gint _tmp0__length1;
	ValaGenieScannerConditional _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	memset (&_tmp1_, 0, sizeof (ValaGenieScannerConditional));
	_vala_array_add11 (&self->priv->conditional_stack, &self->priv->conditional_stack_length1, &self->priv->_conditional_stack_size_, &_tmp1_);
	_tmp3_ = condition;
	if (_tmp3_) {
		gboolean _tmp4_ = FALSE;
		ValaGenieScannerConditional* _tmp5_;
		gint _tmp5__length1;
		_tmp5_ = self->priv->conditional_stack;
		_tmp5__length1 = self->priv->conditional_stack_length1;
		if (_tmp5__length1 == 1) {
			_tmp4_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp6_;
			gint _tmp6__length1;
			ValaGenieScannerConditional* _tmp7_;
			gint _tmp7__length1;
			ValaGenieScannerConditional _tmp8_;
			gboolean _tmp9_;
			_tmp6_ = self->priv->conditional_stack;
			_tmp6__length1 = self->priv->conditional_stack_length1;
			_tmp7_ = self->priv->conditional_stack;
			_tmp7__length1 = self->priv->conditional_stack_length1;
			_tmp8_ = _tmp6_[_tmp7__length1 - 2];
			_tmp9_ = _tmp8_.skip_section;
			_tmp4_ = !_tmp9_;
		}
		_tmp2_ = _tmp4_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaGenieScannerConditional* _tmp10_;
		gint _tmp10__length1;
		ValaGenieScannerConditional* _tmp11_;
		gint _tmp11__length1;
		_tmp10_ = self->priv->conditional_stack;
		_tmp10__length1 = self->priv->conditional_stack_length1;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp10_[_tmp11__length1 - 1].matched = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp12_;
		gint _tmp12__length1;
		ValaGenieScannerConditional* _tmp13_;
		gint _tmp13__length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		_tmp13_ = self->priv->conditional_stack;
		_tmp13__length1 = self->priv->conditional_stack_length1;
		_tmp12_[_tmp13__length1 - 1].skip_section = TRUE;
	}
}


static void
vala_genie_scanner_parse_pp_elif (ValaGenieScanner* self)
{
	gboolean condition = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_space (self);
	condition = vala_genie_scanner_parse_pp_expression (self);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, unexpected #elif");
		_vala_source_reference_unref0 (_tmp7_);
		return;
	}
	_tmp10_ = condition;
	if (_tmp10_) {
		ValaGenieScannerConditional* _tmp11_;
		gint _tmp11__length1;
		ValaGenieScannerConditional* _tmp12_;
		gint _tmp12__length1;
		ValaGenieScannerConditional _tmp13_;
		gboolean _tmp14_;
		_tmp11_ = self->priv->conditional_stack;
		_tmp11__length1 = self->priv->conditional_stack_length1;
		_tmp12_ = self->priv->conditional_stack;
		_tmp12__length1 = self->priv->conditional_stack_length1;
		_tmp13_ = _tmp11_[_tmp12__length1 - 1];
		_tmp14_ = _tmp13_.matched;
		_tmp9_ = !_tmp14_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gboolean _tmp15_ = FALSE;
		ValaGenieScannerConditional* _tmp16_;
		gint _tmp16__length1;
		_tmp16_ = self->priv->conditional_stack;
		_tmp16__length1 = self->priv->conditional_stack_length1;
		if (_tmp16__length1 == 1) {
			_tmp15_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp17_;
			gint _tmp17__length1;
			ValaGenieScannerConditional* _tmp18_;
			gint _tmp18__length1;
			ValaGenieScannerConditional _tmp19_;
			gboolean _tmp20_;
			_tmp17_ = self->priv->conditional_stack;
			_tmp17__length1 = self->priv->conditional_stack_length1;
			_tmp18_ = self->priv->conditional_stack;
			_tmp18__length1 = self->priv->conditional_stack_length1;
			_tmp19_ = _tmp17_[_tmp18__length1 - 2];
			_tmp20_ = _tmp19_.skip_section;
			_tmp15_ = !_tmp20_;
		}
		_tmp8_ = _tmp15_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaGenieScannerConditional* _tmp22_;
		gint _tmp22__length1;
		ValaGenieScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaGenieScannerConditional* _tmp24_;
		gint _tmp24__length1;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].matched = TRUE;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp23_[_tmp24__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp25_;
		gint _tmp25__length1;
		ValaGenieScannerConditional* _tmp26_;
		gint _tmp26__length1;
		_tmp25_ = self->priv->conditional_stack;
		_tmp25__length1 = self->priv->conditional_stack_length1;
		_tmp26_ = self->priv->conditional_stack;
		_tmp26__length1 = self->priv->conditional_stack_length1;
		_tmp25_[_tmp26__length1 - 1].skip_section = TRUE;
	}
}


static void
vala_genie_scanner_parse_pp_else (ValaGenieScanner* self)
{
	gboolean _tmp0_ = FALSE;
	ValaGenieScannerConditional* _tmp1_;
	gint _tmp1__length1;
	gboolean _tmp8_ = FALSE;
	ValaGenieScannerConditional* _tmp9_;
	gint _tmp9__length1;
	ValaGenieScannerConditional* _tmp10_;
	gint _tmp10__length1;
	ValaGenieScannerConditional _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp1_ = self->priv->conditional_stack;
	_tmp1__length1 = self->priv->conditional_stack_length1;
	if (_tmp1__length1 == 0) {
		_tmp0_ = TRUE;
	} else {
		ValaGenieScannerConditional* _tmp2_;
		gint _tmp2__length1;
		ValaGenieScannerConditional* _tmp3_;
		gint _tmp3__length1;
		ValaGenieScannerConditional _tmp4_;
		gboolean _tmp5_;
		_tmp2_ = self->priv->conditional_stack;
		_tmp2__length1 = self->priv->conditional_stack_length1;
		_tmp3_ = self->priv->conditional_stack;
		_tmp3__length1 = self->priv->conditional_stack_length1;
		_tmp4_ = _tmp2_[_tmp3__length1 - 1];
		_tmp5_ = _tmp4_.else_found;
		_tmp0_ = _tmp5_;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "syntax error, unexpected #else");
		_vala_source_reference_unref0 (_tmp7_);
		return;
	}
	_tmp9_ = self->priv->conditional_stack;
	_tmp9__length1 = self->priv->conditional_stack_length1;
	_tmp10_ = self->priv->conditional_stack;
	_tmp10__length1 = self->priv->conditional_stack_length1;
	_tmp11_ = _tmp9_[_tmp10__length1 - 1];
	_tmp12_ = _tmp11_.matched;
	if (!_tmp12_) {
		gboolean _tmp13_ = FALSE;
		ValaGenieScannerConditional* _tmp14_;
		gint _tmp14__length1;
		_tmp14_ = self->priv->conditional_stack;
		_tmp14__length1 = self->priv->conditional_stack_length1;
		if (_tmp14__length1 == 1) {
			_tmp13_ = TRUE;
		} else {
			ValaGenieScannerConditional* _tmp15_;
			gint _tmp15__length1;
			ValaGenieScannerConditional* _tmp16_;
			gint _tmp16__length1;
			ValaGenieScannerConditional _tmp17_;
			gboolean _tmp18_;
			_tmp15_ = self->priv->conditional_stack;
			_tmp15__length1 = self->priv->conditional_stack_length1;
			_tmp16_ = self->priv->conditional_stack;
			_tmp16__length1 = self->priv->conditional_stack_length1;
			_tmp17_ = _tmp15_[_tmp16__length1 - 2];
			_tmp18_ = _tmp17_.skip_section;
			_tmp13_ = !_tmp18_;
		}
		_tmp8_ = _tmp13_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaGenieScannerConditional* _tmp19_;
		gint _tmp19__length1;
		ValaGenieScannerConditional* _tmp20_;
		gint _tmp20__length1;
		ValaGenieScannerConditional* _tmp21_;
		gint _tmp21__length1;
		ValaGenieScannerConditional* _tmp22_;
		gint _tmp22__length1;
		_tmp19_ = self->priv->conditional_stack;
		_tmp19__length1 = self->priv->conditional_stack_length1;
		_tmp20_ = self->priv->conditional_stack;
		_tmp20__length1 = self->priv->conditional_stack_length1;
		_tmp19_[_tmp20__length1 - 1].matched = TRUE;
		_tmp21_ = self->priv->conditional_stack;
		_tmp21__length1 = self->priv->conditional_stack_length1;
		_tmp22_ = self->priv->conditional_stack;
		_tmp22__length1 = self->priv->conditional_stack_length1;
		_tmp21_[_tmp22__length1 - 1].skip_section = FALSE;
	} else {
		ValaGenieScannerConditional* _tmp23_;
		gint _tmp23__length1;
		ValaGenieScannerConditional* _tmp24_;
		gint _tmp24__length1;
		_tmp23_ = self->priv->conditional_stack;
		_tmp23__length1 = self->priv->conditional_stack_length1;
		_tmp24_ = self->priv->conditional_stack;
		_tmp24__length1 = self->priv->conditional_stack_length1;
		_tmp23_[_tmp24__length1 - 1].skip_section = TRUE;
	}
}


static void
vala_genie_scanner_parse_pp_endif (ValaGenieScanner* self)
{
	ValaGenieScannerConditional* _tmp0_;
	gint _tmp0__length1;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	vala_genie_scanner_pp_eol (self);
	_tmp0_ = self->priv->conditional_stack;
	_tmp0__length1 = self->priv->conditional_stack_length1;
	if (_tmp0__length1 == 0) {
		ValaSourceReference* _tmp1_;
		ValaSourceReference* _tmp2_;
		_tmp1_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp2_ = _tmp1_;
		vala_report_error (_tmp2_, "syntax error, unexpected #endif");
		_vala_source_reference_unref0 (_tmp2_);
		return;
	}
	_tmp3_ = self->priv->conditional_stack_length1;
	self->priv->conditional_stack_length1 = _tmp3_ - 1;
}


static gboolean
vala_genie_scanner_parse_pp_symbol (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gint len = 0;
	gint _tmp8_;
	gchar* identifier = NULL;
	gchar* _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gchar* _tmp14_;
	gboolean defined = FALSE;
	const gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	len = 0;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp1_ = self->priv->current;
		_tmp2_ = self->priv->end;
		if (_tmp1_ < _tmp2_) {
			gchar* _tmp3_;
			gchar _tmp4_;
			_tmp3_ = self->priv->current;
			_tmp4_ = _tmp3_[0];
			_tmp0_ = vala_genie_scanner_is_ident_char (self, _tmp4_);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		_tmp7_ = len;
		len = _tmp7_ + 1;
	}
	_tmp8_ = len;
	if (_tmp8_ == 0) {
		ValaSourceReference* _tmp9_;
		ValaSourceReference* _tmp10_;
		_tmp9_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp10_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp10_);
		result = FALSE;
		return result;
	}
	_tmp11_ = self->priv->current;
	_tmp12_ = len;
	_tmp13_ = len;
	_tmp14_ = string_substring ((const gchar*) (_tmp11_ - _tmp12_), (glong) 0, (glong) _tmp13_);
	identifier = _tmp14_;
	_tmp15_ = identifier;
	if (g_strcmp0 (_tmp15_, "true") == 0) {
		defined = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = identifier;
		if (g_strcmp0 (_tmp16_, "false") == 0) {
			defined = FALSE;
		} else {
			ValaSourceFile* _tmp17_;
			ValaCodeContext* _tmp18_;
			ValaCodeContext* _tmp19_;
			const gchar* _tmp20_;
			_tmp17_ = self->priv->_source_file;
			_tmp18_ = vala_source_file_get_context (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = identifier;
			defined = vala_code_context_is_defined (_tmp19_, _tmp20_);
		}
	}
	result = defined;
	_g_free0 (identifier);
	return result;
}


static gboolean
vala_genie_scanner_parse_pp_primary_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->current;
	_tmp1_ = self->priv->end;
	if (_tmp0_ >= _tmp1_) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_genie_scanner_get_source_reference (self, 0, 0);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "syntax error, expected identifier");
		_vala_source_reference_unref0 (_tmp3_);
	} else {
		gchar* _tmp4_;
		gchar _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_[0];
		if (vala_genie_scanner_is_ident_char (self, _tmp5_)) {
			result = vala_genie_scanner_parse_pp_symbol (self);
			return result;
		} else {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[0];
			if (_tmp7_ == '(') {
				gchar* _tmp8_;
				gint _tmp9_;
				gboolean _result_ = FALSE;
				gboolean _tmp10_ = FALSE;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp8_ = self->priv->current;
				self->priv->current = _tmp8_ + 1;
				_tmp9_ = self->priv->column;
				self->priv->column = _tmp9_ + 1;
				vala_genie_scanner_pp_space (self);
				_result_ = vala_genie_scanner_parse_pp_expression (self);
				vala_genie_scanner_pp_space (self);
				_tmp11_ = self->priv->current;
				_tmp12_ = self->priv->end;
				if (_tmp11_ < _tmp12_) {
					gchar* _tmp13_;
					gchar _tmp14_;
					_tmp13_ = self->priv->current;
					_tmp14_ = _tmp13_[0];
					_tmp10_ = _tmp14_ == ')';
				} else {
					_tmp10_ = FALSE;
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					gint _tmp16_;
					_tmp15_ = self->priv->current;
					self->priv->current = _tmp15_ + 1;
					_tmp16_ = self->priv->column;
					self->priv->column = _tmp16_ + 1;
				} else {
					ValaSourceReference* _tmp17_;
					ValaSourceReference* _tmp18_;
					_tmp17_ = vala_genie_scanner_get_source_reference (self, 0, 0);
					_tmp18_ = _tmp17_;
					vala_report_error (_tmp18_, "syntax error, expected `)'");
					_vala_source_reference_unref0 (_tmp18_);
				}
				result = _result_;
				return result;
			} else {
				ValaSourceReference* _tmp19_;
				ValaSourceReference* _tmp20_;
				_tmp19_ = vala_genie_scanner_get_source_reference (self, 0, 0);
				_tmp20_ = _tmp19_;
				vala_report_error (_tmp20_, "syntax error, expected identifier");
				_vala_source_reference_unref0 (_tmp20_);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean
vala_genie_scanner_parse_pp_unary_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->current;
	_tmp2_ = self->priv->end;
	if (_tmp1_ < _tmp2_) {
		gchar* _tmp3_;
		gchar _tmp4_;
		_tmp3_ = self->priv->current;
		_tmp4_ = _tmp3_[0];
		_tmp0_ = _tmp4_ == '!';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		gint _tmp6_;
		_tmp5_ = self->priv->current;
		self->priv->current = _tmp5_ + 1;
		_tmp6_ = self->priv->column;
		self->priv->column = _tmp6_ + 1;
		vala_genie_scanner_pp_space (self);
		result = !vala_genie_scanner_parse_pp_unary_expression (self);
		return result;
	}
	result = vala_genie_scanner_parse_pp_primary_expression (self);
	return result;
}


static gboolean
vala_genie_scanner_parse_pp_equality_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_unary_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '=';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '=';
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			gchar* _tmp8_;
			gint _tmp9_;
			gboolean right = FALSE;
			gboolean _tmp10_;
			gboolean _tmp11_;
			_tmp8_ = self->priv->current;
			self->priv->current = _tmp8_ + 2;
			_tmp9_ = self->priv->column;
			self->priv->column = _tmp9_ + 2;
			vala_genie_scanner_pp_space (self);
			right = vala_genie_scanner_parse_pp_unary_expression (self);
			_tmp10_ = left;
			_tmp11_ = right;
			left = _tmp10_ == _tmp11_;
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp14_ = self->priv->current;
			_tmp15_ = self->priv->end;
			if (_tmp14_ < (_tmp15_ - 1)) {
				gchar* _tmp16_;
				gchar _tmp17_;
				_tmp16_ = self->priv->current;
				_tmp17_ = _tmp16_[0];
				_tmp13_ = _tmp17_ == '!';
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				gchar* _tmp18_;
				gchar _tmp19_;
				_tmp18_ = self->priv->current;
				_tmp19_ = _tmp18_[1];
				_tmp12_ = _tmp19_ == '=';
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				gchar* _tmp20_;
				gint _tmp21_;
				gboolean right = FALSE;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp20_ = self->priv->current;
				self->priv->current = _tmp20_ + 2;
				_tmp21_ = self->priv->column;
				self->priv->column = _tmp21_ + 2;
				vala_genie_scanner_pp_space (self);
				right = vala_genie_scanner_parse_pp_unary_expression (self);
				_tmp22_ = left;
				_tmp23_ = right;
				left = _tmp22_ != _tmp23_;
			} else {
				break;
			}
		}
	}
	result = left;
	return result;
}


static gboolean
vala_genie_scanner_parse_pp_and_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_equality_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		gboolean right = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '&';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '&';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_equality_expression (self);
		_tmp11_ = left;
		if (_tmp11_) {
			gboolean _tmp12_;
			_tmp12_ = right;
			_tmp10_ = _tmp12_;
		} else {
			_tmp10_ = FALSE;
		}
		left = _tmp10_;
	}
	result = left;
	return result;
}


static gboolean
vala_genie_scanner_parse_pp_or_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	gboolean left = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	left = vala_genie_scanner_parse_pp_and_expression (self);
	vala_genie_scanner_pp_space (self);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp8_;
		gint _tmp9_;
		gboolean right = FALSE;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_;
		_tmp2_ = self->priv->current;
		_tmp3_ = self->priv->end;
		if (_tmp2_ < (_tmp3_ - 1)) {
			gchar* _tmp4_;
			gchar _tmp5_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_[0];
			_tmp1_ = _tmp5_ == '|';
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			gchar* _tmp6_;
			gchar _tmp7_;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_[1];
			_tmp0_ = _tmp7_ == '|';
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp8_ = self->priv->current;
		self->priv->current = _tmp8_ + 2;
		_tmp9_ = self->priv->column;
		self->priv->column = _tmp9_ + 2;
		vala_genie_scanner_pp_space (self);
		right = vala_genie_scanner_parse_pp_and_expression (self);
		_tmp11_ = left;
		if (_tmp11_) {
			_tmp10_ = TRUE;
		} else {
			gboolean _tmp12_;
			_tmp12_ = right;
			_tmp10_ = _tmp12_;
		}
		left = _tmp10_;
	}
	result = left;
	return result;
}


static gboolean
vala_genie_scanner_parse_pp_expression (ValaGenieScanner* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_genie_scanner_parse_pp_or_expression (self);
	return result;
}


ValaSourceFile*
vala_genie_scanner_get_source_file (ValaGenieScanner* self)
{
	ValaSourceFile* result;
	ValaSourceFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_source_file;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static void
vala_genie_scanner_set_source_file (ValaGenieScanner* self,
                                    ValaSourceFile* value)
{
	ValaSourceFile* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_source_file_ref0 (value);
	_vala_source_file_unref0 (self->priv->_source_file);
	self->priv->_source_file = _tmp0_;
}


gint
vala_genie_scanner_get_indent_spaces (ValaGenieScanner* self)
{
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_indent_spaces;
	result = _tmp0_;
	return result;
}


void
vala_genie_scanner_set_indent_spaces (ValaGenieScanner* self,
                                      gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_indent_spaces = value;
}


static ValaGenieScannerConditional*
vala_genie_scanner_conditional_dup (const ValaGenieScannerConditional* self)
{
	ValaGenieScannerConditional* dup;
	dup = g_new0 (ValaGenieScannerConditional, 1);
	memcpy (dup, self, sizeof (ValaGenieScannerConditional));
	return dup;
}


static void
vala_genie_scanner_conditional_free (ValaGenieScannerConditional* self)
{
	g_free (self);
}


static GType
vala_genie_scanner_conditional_get_type (void)
{
	static volatile gsize vala_genie_scanner_conditional_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_conditional_type_id__volatile)) {
		GType vala_genie_scanner_conditional_type_id;
		vala_genie_scanner_conditional_type_id = g_boxed_type_register_static ("ValaGenieScannerConditional", (GBoxedCopyFunc) vala_genie_scanner_conditional_dup, (GBoxedFreeFunc) vala_genie_scanner_conditional_free);
		g_once_init_leave (&vala_genie_scanner_conditional_type_id__volatile, vala_genie_scanner_conditional_type_id);
	}
	return vala_genie_scanner_conditional_type_id__volatile;
}


static void
vala_genie_value_scanner_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_genie_value_scanner_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_genie_scanner_unref (value->data[0].v_pointer);
	}
}


static void
vala_genie_value_scanner_copy_value (const GValue* src_value,
                                     GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_genie_scanner_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_genie_value_scanner_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_genie_value_scanner_collect_value (GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGenieScanner * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_genie_scanner_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_genie_value_scanner_lcopy_value (const GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	ValaGenieScanner ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_genie_scanner_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_genie_param_spec_scanner (const gchar* name,
                               const gchar* nick,
                               const gchar* blurb,
                               GType object_type,
                               GParamFlags flags)
{
	ValaGenieParamSpecScanner* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GENIE_TYPE_SCANNER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_genie_value_get_scanner (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER), NULL);
	return value->data[0].v_pointer;
}


void
vala_genie_value_set_scanner (GValue* value,
                              gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_genie_scanner_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}


void
vala_genie_value_take_scanner (GValue* value,
                               gpointer v_object)
{
	ValaGenieScanner * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GENIE_TYPE_SCANNER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GENIE_TYPE_SCANNER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_genie_scanner_unref (old);
	}
}


static void
vala_genie_scanner_class_init (ValaGenieScannerClass * klass)
{
	vala_genie_scanner_parent_class = g_type_class_peek_parent (klass);
	((ValaGenieScannerClass *) klass)->finalize = vala_genie_scanner_finalize;
	g_type_class_add_private (klass, sizeof (ValaGenieScannerPrivate));
}


static void
vala_genie_scanner_instance_init (ValaGenieScanner * self)
{
	self->priv = VALA_GENIE_SCANNER_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_genie_scanner_finalize (ValaGenieScanner * obj)
{
	ValaGenieScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GENIE_TYPE_SCANNER, ValaGenieScanner);
	g_signal_handlers_destroy (self);
	_vala_source_file_unref0 (self->priv->_source_file);
	_vala_comment_unref0 (self->priv->_comment);
	self->priv->conditional_stack = (g_free (self->priv->conditional_stack), NULL);
	self->priv->state_stack = (g_free (self->priv->state_stack), NULL);
}


/**
 * Lexical scanner for Genie source files.
 */
GType
vala_genie_scanner_get_type (void)
{
	static volatile gsize vala_genie_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&vala_genie_scanner_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_genie_value_scanner_init, vala_genie_value_scanner_free_value, vala_genie_value_scanner_copy_value, vala_genie_value_scanner_peek_pointer, "p", vala_genie_value_scanner_collect_value, "p", vala_genie_value_scanner_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGenieScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_genie_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGenieScanner), 0, (GInstanceInitFunc) vala_genie_scanner_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_genie_scanner_type_id;
		vala_genie_scanner_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGenieScanner", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_genie_scanner_type_id__volatile, vala_genie_scanner_type_id);
	}
	return vala_genie_scanner_type_id__volatile;
}


gpointer
vala_genie_scanner_ref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_genie_scanner_unref (gpointer instance)
{
	ValaGenieScanner * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GENIE_SCANNER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



