#! /bin/bash

# compile all examples

for f in $@
do
  body=$(basename $f .cc)
  common_flags="-O3 -Wno-abi -std=c++11 -march=native -mavx2 -pthread"

#   avx_flags="-O3 -Wno-abi -std=c++11 -mavx -pthread"
  
# use this flags to avoid multithreading:
#  -DVSPLINE_SINGLETHREAD"

  for compiler in clang++ # g++
  do
  
    echo compiling $body with:

    echo $compiler $common_flags -otv_$body $f -lvigraimpex
    $compiler $common_flags -otv_$body $f -lvigraimpex
    
    echo $compiler -DUSE_VC $common_flags -o$body $f -lVc -lvigraimpex
    $compiler -DUSE_VC $common_flags -o$body $f -lVc -lvigraimpex

  done

done
