/*
 * Decompiled with CFR 0.152.
 */
package rene.dialogs;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import rene.dialogs.ItemEditorElement;
import rene.dialogs.ItemPanel;
import rene.gui.ButtonAction;
import rene.gui.CloseDialog;
import rene.gui.Global;
import rene.gui.MyLabel;
import rene.gui.MyList;
import rene.gui.MyPanel;
import rene.gui.Panel3D;

public class ItemEditor
extends CloseDialog
implements ItemListener {
    Frame F;
    MyList L;
    boolean Aborted = true;
    Vector V;
    ItemPanel P;
    String Name;
    int Displayed = -1;
    public static final int NONE = 0;
    public static final int SAVE = 1;
    public static final int LOAD = 2;
    int Action = 0;

    public ItemEditor(Frame frame, ItemPanel itemPanel, Vector vector, String string, String string2) {
        this(frame, itemPanel, vector, string, string2, true, true, false, "");
    }

    public ItemEditor(Frame frame, ItemPanel itemPanel, Vector vector, String string, String string2, boolean bl, boolean bl2, boolean bl3, String string3) {
        super(frame, Global.name(string + ".title"), true);
        MyPanel myPanel;
        this.Name = string;
        this.F = frame;
        this.P = itemPanel;
        this.setLayout(new BorderLayout());
        MyPanel myPanel2 = new MyPanel();
        myPanel2.add(new MyLabel(string2));
        this.add("North", myPanel2);
        MyPanel myPanel3 = new MyPanel();
        myPanel3.setLayout(new BorderLayout(5, 5));
        this.L = new MyList(10);
        myPanel3.add("West", this.L);
        this.L.addItemListener(this);
        MyPanel myPanel4 = new MyPanel();
        myPanel4.setLayout(new BorderLayout());
        myPanel4.add("North", this.P);
        myPanel4.add("Center", new MyPanel());
        myPanel3.add("Center", myPanel4);
        this.add("Center", new Panel3D(myPanel3));
        MyPanel myPanel5 = new MyPanel();
        myPanel5.setLayout(new GridLayout(0, 1));
        if (bl) {
            myPanel = new MyPanel();
            myPanel.add(new ButtonAction(this, Global.name("itemeditor.insert"), "Insert"));
            myPanel.add(new ButtonAction(this, Global.name("itemeditor.new"), "New"));
            myPanel.add(new ButtonAction(this, Global.name("itemeditor.delete"), "Delete"));
            myPanel5.add(myPanel);
        }
        if (bl2) {
            myPanel = new MyPanel();
            myPanel.add(new ButtonAction(this, Global.name("itemeditor.down"), "Down"));
            myPanel.add(new ButtonAction(this, Global.name("itemeditor.up"), "Up"));
            myPanel5.add(myPanel);
        }
        myPanel = new MyPanel();
        myPanel.setLayout(new FlowLayout(2));
        myPanel.add(new ButtonAction(this, Global.name("OK"), "OK"));
        myPanel.add(new ButtonAction(this, Global.name("abort"), "Close"));
        myPanel5.add(myPanel);
        if (bl3) {
            MyPanel myPanel6 = new MyPanel();
            myPanel6.setLayout(new FlowLayout(2));
            myPanel6.add(new ButtonAction(this, Global.name("save"), "Save"));
            myPanel6.add(new ButtonAction(this, Global.name("load"), "Load"));
            if (!string3.equals("")) {
                myPanel6.add(new ButtonAction(this, string3, "Extra"));
            }
            myPanel5.add(myPanel6);
        }
        this.add("South", new Panel3D(myPanel5));
        this.V = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            this.V.addElement(vector.elementAt(i));
        }
        this.init();
        this.pack();
    }

    public void init() {
        for (int i = 0; i < this.V.size(); ++i) {
            ItemEditorElement itemEditorElement = (ItemEditorElement)this.V.elementAt(i);
            this.L.add(itemEditorElement.getName());
        }
        if (this.V.size() > 0) {
            this.L.select(0);
            this.select();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.L) {
            if (this.Displayed >= 0) {
                this.define(this.Displayed);
            }
            this.select();
        }
    }

    public void select() {
        int n = this.L.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.P.display((ItemEditorElement)this.V.elementAt(n));
        this.Displayed = n;
    }

    public void doAction(String string) {
        if (string.equals("Delete")) {
            this.delete();
        } else if (string.equals("Insert")) {
            this.insert();
        } else if (string.equals("New")) {
            this.P.newElement();
        } else if (string.equals("Up")) {
            this.up();
        } else if (string.equals("Down")) {
            this.down();
        } else if (string.equals("OK")) {
            this.noteSize(this.Name);
            this.define();
            this.Aborted = false;
            this.doclose();
        } else if (string.equals("Help")) {
            this.P.help();
        } else if (string.equals("Save")) {
            this.define();
            this.Action = 1;
            this.Aborted = false;
            this.doclose();
        } else if (string.equals("Load")) {
            this.define();
            this.Action = 2;
            this.Aborted = false;
            this.doclose();
        } else if (string.equals("Extra")) {
            if (this.P.extra(this.V)) {
                this.Aborted = false;
                this.doclose();
            }
        } else {
            super.doAction(string);
        }
    }

    void insert() {
        String string = this.P.getName();
        int n = this.L.getSelectedIndex();
        if (n < 0) {
            n = 0;
        }
        while (this.find(string)) {
            string = string + "*";
        }
        this.P.setName(string);
        ItemEditorElement itemEditorElement = this.P.getElement();
        this.L.add(itemEditorElement.getName(), n);
        this.L.select(n);
        this.V.insertElementAt(itemEditorElement, n);
    }

    void define(int n) {
        String string = this.P.getName();
        if (string.equals("")) {
            return;
        }
        if (!this.L.getItem(n).equals(string)) {
            this.L.replaceItem(string, n);
        }
        this.V.setElementAt(this.P.getElement(), n);
        this.P.notifyChange(this.V, n);
    }

    void define() {
        int n = this.L.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.define(n);
        this.L.select(n);
    }

    boolean find(String string) {
        for (int i = 0; i < this.V.size(); ++i) {
            ItemEditorElement itemEditorElement = (ItemEditorElement)this.V.elementAt(i);
            if (!itemEditorElement.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    void delete() {
        int n = this.L.getSelectedIndex();
        if (n < 0) {
            return;
        }
        this.V.removeElementAt(n);
        this.L.remove(n);
        if (this.L.getItemCount() == 0) {
            return;
        }
        if (n >= this.L.getItemCount()) {
            --n;
        }
        this.L.select(n);
        this.select();
    }

    void down() {
        this.define();
        int n = this.L.getSelectedIndex();
        if (n < 0 || n + 1 >= this.V.size()) {
            return;
        }
        ItemEditorElement itemEditorElement = (ItemEditorElement)this.V.elementAt(n);
        ItemEditorElement itemEditorElement2 = (ItemEditorElement)this.V.elementAt(n + 1);
        this.V.setElementAt(itemEditorElement2, n);
        this.V.setElementAt(itemEditorElement, n + 1);
        this.L.replaceItem(itemEditorElement2.getName(), n);
        this.L.replaceItem(itemEditorElement.getName(), n + 1);
        this.L.select(++n);
        this.select();
    }

    void up() {
        this.define();
        int n = this.L.getSelectedIndex();
        if (n <= 0) {
            return;
        }
        ItemEditorElement itemEditorElement = (ItemEditorElement)this.V.elementAt(n);
        ItemEditorElement itemEditorElement2 = (ItemEditorElement)this.V.elementAt(n - 1);
        this.V.setElementAt(itemEditorElement2, n);
        this.V.setElementAt(itemEditorElement, n - 1);
        this.L.replaceItem(itemEditorElement2.getName(), n);
        this.L.replaceItem(itemEditorElement.getName(), n - 1);
        this.L.select(--n);
        this.select();
    }

    public boolean isAborted() {
        return this.Aborted;
    }

    public Vector getElements() {
        return this.V;
    }

    public int getAction() {
        return this.Action;
    }
}

